/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.compare;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.string.StringReplace;
import com.helger.base.system.SystemHelper;
import com.helger.cache.impl.Cache;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CollatorHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollatorHelper.class);
    private static final Cache<Locale, Collator> COLLATOR_CACHE = Cache.builder().valueProvider(locale -> {
        if (locale == null) {
            LOGGER.error("Very weird: no locale passed in. Falling back to system locale.");
            return Collator.getInstance(SystemHelper.getSystemLocale());
        }
        Collator collator = Collator.getInstance(locale);
        if (!(collator instanceof RuleBasedCollator)) {
            LOGGER.warn("Collator.getInstance did not return a RulleBasedCollator but a " + collator.getClass().getName());
            return collator;
        }
        try {
            String string = ((RuleBasedCollator)collator).getRules();
            if (!string.contains("<'.'<")) {
                LOGGER.warn("Failed to identify the Collator rule part to be replaced. Locale used: " + String.valueOf(locale));
                return collator;
            }
            String string2 = StringReplace.replaceAll((String)string, (String)"<'.'<", (CharSequence)"<' '<'.'<");
            RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(string2);
            ruleBasedCollator.setStrength(2);
            ruleBasedCollator.setDecomposition(2);
            return ruleBasedCollator;
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("Failed to parse collator rule set for locale " + String.valueOf(locale), parseException);
        }
    }).maxSize(500).name(CollatorHelper.class.getName() + "$Cache").build();
    private static final CollatorHelper INSTANCE = new CollatorHelper();

    private CollatorHelper() {
    }

    @ReturnsMutableCopy
    public static @NonNull Collator getCollatorSpaceBeforeDot(@Nullable Locale locale) {
        Locale locale2 = locale == null ? SystemHelper.getSystemLocale() : locale;
        return (Collator)((Collator)COLLATOR_CACHE.getFromCache((Object)locale2)).clone();
    }

    public static @NonNull EChange clearCache() {
        return COLLATOR_CACHE.clearCache();
    }
}

