/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resolve;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.text.IHasText;
import com.helger.text.IHasTextWithArgs;
import com.helger.text.resolve.EnumTextResolverWithPropertiesOverrideAndFallback;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@ThreadSafe
public final class DefaultTextResolver
extends EnumTextResolverWithPropertiesOverrideAndFallback {
    private static boolean s_bDefaultInstantiated = false;

    private DefaultTextResolver() {
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static DefaultTextResolver getInstance() {
        DefaultTextResolver defaultTextResolver = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return defaultTextResolver;
    }

    @Nullable
    public static String getTextStatic(@Nonnull Enum<?> enum_, @Nonnull IHasText iHasText, @Nonnull Locale locale) {
        return DefaultTextResolver.getInstance().getText(enum_, iHasText, locale);
    }

    @Nullable
    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use getTextStatic instead when no argument is needed!")
    public static String getTextWithArgsStatic(@Nonnull Enum<?> enum_, @Nonnull IHasTextWithArgs iHasTextWithArgs, @Nonnull Locale locale) {
        return DefaultTextResolver.getTextStatic(enum_, iHasTextWithArgs, locale);
    }

    @Nullable
    public static String getTextWithArgsStatic(@Nonnull Enum<?> enum_, @Nonnull IHasTextWithArgs iHasTextWithArgs, @Nonnull Locale locale, Object ... objectArray) {
        return DefaultTextResolver.getInstance().getTextWithArgs(enum_, iHasTextWithArgs, locale, objectArray);
    }

    private static final class SingletonHolder {
        private static final DefaultTextResolver INSTANCE = new DefaultTextResolver();

        private SingletonHolder() {
        }
    }
}

