/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.codepoint;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.text.codepoint.Codepoint;
import com.helger.text.codepoint.CodepointIteratorRestricted;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.function.IntPredicate;

public interface ICodepointIterator
extends Iterator<Codepoint> {
    @Override
    default public boolean hasNext() {
        return this.remaining() > 0;
    }

    @CheckForSigned
    public int lastPosition();

    @Nullable
    public char[] nextChars();

    @Nullable
    public char[] peekChars();

    @Override
    @Nullable
    public Codepoint next();

    @Nullable
    public Codepoint peek();

    @Nullable
    public Codepoint peek(@Nonnegative int var1);

    public void position(@Nonnegative int var1);

    @Nonnegative
    public int position();

    @Nonnegative
    public int limit();

    @Nonnegative
    public int remaining();

    public boolean isHigh(@Nonnegative int var1);

    public boolean isLow(@Nonnegative int var1);

    @Nonnull
    default public CodepointIteratorRestricted restrict(@Nonnull IntPredicate intPredicate) {
        return this.restrict(intPredicate, false);
    }

    @Nonnull
    default public CodepointIteratorRestricted restrict(@Nonnull IntPredicate intPredicate, boolean bl) {
        return this.restrict(intPredicate, bl, false);
    }

    @Nonnull
    public CodepointIteratorRestricted restrict(@Nonnull IntPredicate var1, boolean var2, boolean var3);
}

