/*
 * Decompiled with CFR 0.152.
 */
package com.helger.statistics.impl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.statistics.api.IMutableStatisticsHandlerCache;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedSize;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedTimer;
import com.helger.statistics.api.IMutableStatisticsHandlerSize;
import com.helger.statistics.api.IMutableStatisticsHandlerTimer;
import com.helger.statistics.impl.StatisticsHandlerCache;
import com.helger.statistics.impl.StatisticsHandlerCounter;
import com.helger.statistics.impl.StatisticsHandlerKeyedCounter;
import com.helger.statistics.impl.StatisticsHandlerKeyedSize;
import com.helger.statistics.impl.StatisticsHandlerKeyedTimer;
import com.helger.statistics.impl.StatisticsHandlerSize;
import com.helger.statistics.impl.StatisticsHandlerTimer;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class StatisticsManager {
    private static final SimpleReadWriteLock RWL_CACHE = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_TIMER = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_KEYED_TIMER = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_SIZE = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_KEYED_SIZE = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_COUNTER = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_KEYED_COUNTER = new SimpleReadWriteLock();
    private static final ICommonsMap<String, StatisticsHandlerCache> HDL_CACHE = new CommonsHashMap();
    private static final ICommonsMap<String, StatisticsHandlerTimer> HDL_TIMER = new CommonsHashMap();
    private static final ICommonsMap<String, StatisticsHandlerKeyedTimer> HDL_KEYED_TIMER = new CommonsHashMap();
    private static final ICommonsMap<String, StatisticsHandlerSize> HDL_SIZE = new CommonsHashMap();
    private static final ICommonsMap<String, StatisticsHandlerKeyedSize> HDL_KEYED_SIZE = new CommonsHashMap();
    private static final ICommonsMap<String, StatisticsHandlerCounter> HDL_COUNTER = new CommonsHashMap();
    private static final ICommonsMap<String, StatisticsHandlerKeyedCounter> HDL_KEYED_COUNTER = new CommonsHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsManager.class);
    private static final StatisticsManager INSTANCE = new StatisticsManager();

    private StatisticsManager() {
    }

    public static @NonNull IMutableStatisticsHandlerCache getCacheHandler(@NonNull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return StatisticsManager.getCacheHandler(clazz.getName());
    }

    public static @NonNull IMutableStatisticsHandlerCache getCacheHandler(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StatisticsHandlerCache statisticsHandlerCache = (StatisticsHandlerCache)RWL_CACHE.readLockedGet(() -> (StatisticsHandlerCache)HDL_CACHE.get((Object)string));
        if (statisticsHandlerCache == null) {
            statisticsHandlerCache = (StatisticsHandlerCache)RWL_CACHE.writeLockedGet(() -> (StatisticsHandlerCache)HDL_CACHE.computeIfAbsent((Object)string, string -> new StatisticsHandlerCache()));
        }
        return statisticsHandlerCache;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllCacheHandler() {
        return (ICommonsSet)RWL_CACHE.readLockedGet(() -> HDL_CACHE.copyOfKeySet());
    }

    public static @NonNull IMutableStatisticsHandlerTimer getTimerHandler(@NonNull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return StatisticsManager.getTimerHandler(clazz.getName());
    }

    public static @NonNull IMutableStatisticsHandlerTimer getTimerHandler(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StatisticsHandlerTimer statisticsHandlerTimer = (StatisticsHandlerTimer)RWL_TIMER.readLockedGet(() -> (StatisticsHandlerTimer)HDL_TIMER.get((Object)string));
        if (statisticsHandlerTimer == null) {
            statisticsHandlerTimer = (StatisticsHandlerTimer)RWL_TIMER.writeLockedGet(() -> (StatisticsHandlerTimer)HDL_TIMER.computeIfAbsent((Object)string, string -> new StatisticsHandlerTimer()));
        }
        return statisticsHandlerTimer;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllTimerHandler() {
        return (ICommonsSet)RWL_TIMER.readLockedGet(() -> HDL_TIMER.copyOfKeySet());
    }

    public static @NonNull IMutableStatisticsHandlerKeyedTimer getKeyedTimerHandler(@NonNull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return StatisticsManager.getKeyedTimerHandler(clazz.getName());
    }

    public static @NonNull IMutableStatisticsHandlerKeyedTimer getKeyedTimerHandler(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StatisticsHandlerKeyedTimer statisticsHandlerKeyedTimer = (StatisticsHandlerKeyedTimer)RWL_KEYED_TIMER.readLockedGet(() -> (StatisticsHandlerKeyedTimer)HDL_KEYED_TIMER.get((Object)string));
        if (statisticsHandlerKeyedTimer == null) {
            statisticsHandlerKeyedTimer = (StatisticsHandlerKeyedTimer)RWL_KEYED_TIMER.writeLockedGet(() -> (StatisticsHandlerKeyedTimer)HDL_KEYED_TIMER.computeIfAbsent((Object)string, string -> new StatisticsHandlerKeyedTimer()));
        }
        return statisticsHandlerKeyedTimer;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllKeyedTimerHandler() {
        return (ICommonsSet)RWL_KEYED_TIMER.readLockedGet(() -> HDL_KEYED_TIMER.copyOfKeySet());
    }

    public static @NonNull IMutableStatisticsHandlerSize getSizeHandler(@NonNull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return StatisticsManager.getSizeHandler(clazz.getName());
    }

    public static @NonNull IMutableStatisticsHandlerSize getSizeHandler(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StatisticsHandlerSize statisticsHandlerSize = (StatisticsHandlerSize)RWL_SIZE.readLockedGet(() -> (StatisticsHandlerSize)HDL_SIZE.get((Object)string));
        if (statisticsHandlerSize == null) {
            statisticsHandlerSize = (StatisticsHandlerSize)RWL_SIZE.writeLockedGet(() -> (StatisticsHandlerSize)HDL_SIZE.computeIfAbsent((Object)string, string -> new StatisticsHandlerSize()));
        }
        return statisticsHandlerSize;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllSizeHandler() {
        return (ICommonsSet)RWL_SIZE.readLockedGet(() -> HDL_SIZE.copyOfKeySet());
    }

    public static @NonNull IMutableStatisticsHandlerKeyedSize getKeyedSizeHandler(@NonNull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return StatisticsManager.getKeyedSizeHandler(clazz.getName());
    }

    public static @NonNull IMutableStatisticsHandlerKeyedSize getKeyedSizeHandler(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StatisticsHandlerKeyedSize statisticsHandlerKeyedSize = (StatisticsHandlerKeyedSize)RWL_KEYED_SIZE.readLockedGet(() -> (StatisticsHandlerKeyedSize)HDL_KEYED_SIZE.get((Object)string));
        if (statisticsHandlerKeyedSize == null) {
            statisticsHandlerKeyedSize = (StatisticsHandlerKeyedSize)RWL_KEYED_SIZE.writeLockedGet(() -> (StatisticsHandlerKeyedSize)HDL_KEYED_SIZE.computeIfAbsent((Object)string, string -> new StatisticsHandlerKeyedSize()));
        }
        return statisticsHandlerKeyedSize;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllKeyedSizeHandler() {
        return (ICommonsSet)RWL_KEYED_SIZE.readLockedGet(() -> HDL_KEYED_SIZE.copyOfKeySet());
    }

    public static @NonNull IMutableStatisticsHandlerCounter getCounterHandler(@NonNull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return StatisticsManager.getCounterHandler(clazz.getName());
    }

    public static @NonNull IMutableStatisticsHandlerCounter getCounterHandler(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StatisticsHandlerCounter statisticsHandlerCounter = (StatisticsHandlerCounter)RWL_COUNTER.readLockedGet(() -> (StatisticsHandlerCounter)HDL_COUNTER.get((Object)string));
        if (statisticsHandlerCounter == null) {
            statisticsHandlerCounter = (StatisticsHandlerCounter)RWL_COUNTER.writeLockedGet(() -> (StatisticsHandlerCounter)HDL_COUNTER.computeIfAbsent((Object)string, string -> new StatisticsHandlerCounter()));
        }
        return statisticsHandlerCounter;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllCounterHandler() {
        return (ICommonsSet)RWL_COUNTER.readLockedGet(() -> HDL_COUNTER.copyOfKeySet());
    }

    public static @NonNull IMutableStatisticsHandlerKeyedCounter getKeyedCounterHandler(@NonNull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return StatisticsManager.getKeyedCounterHandler(clazz.getName());
    }

    public static @NonNull IMutableStatisticsHandlerKeyedCounter getKeyedCounterHandler(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StatisticsHandlerKeyedCounter statisticsHandlerKeyedCounter = (StatisticsHandlerKeyedCounter)RWL_KEYED_COUNTER.readLockedGet(() -> (StatisticsHandlerKeyedCounter)HDL_KEYED_COUNTER.get((Object)string));
        if (statisticsHandlerKeyedCounter == null) {
            statisticsHandlerKeyedCounter = (StatisticsHandlerKeyedCounter)RWL_KEYED_COUNTER.writeLockedGet(() -> (StatisticsHandlerKeyedCounter)HDL_KEYED_COUNTER.computeIfAbsent((Object)string, string -> new StatisticsHandlerKeyedCounter()));
        }
        return statisticsHandlerKeyedCounter;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllKeyedCounterHandler() {
        return (ICommonsSet)RWL_KEYED_COUNTER.readLockedGet(() -> HDL_KEYED_COUNTER.copyOfKeySet());
    }

    public static void clearCache() {
        RWL_CACHE.writeLocked(() -> HDL_CACHE.clear());
        RWL_TIMER.writeLocked(() -> HDL_TIMER.clear());
        RWL_KEYED_TIMER.writeLocked(() -> HDL_KEYED_TIMER.clear());
        RWL_SIZE.writeLocked(() -> HDL_SIZE.clear());
        RWL_KEYED_SIZE.writeLocked(() -> HDL_KEYED_SIZE.clear());
        RWL_COUNTER.writeLocked(() -> HDL_COUNTER.clear());
        RWL_KEYED_COUNTER.writeLocked(() -> HDL_KEYED_COUNTER.clear());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + StatisticsManager.class.getName());
        }
    }
}

