/*
 * Decompiled with CFR 0.152.
 */
package com.helger.statistics.visit;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.ICommonsList;
import com.helger.statistics.api.IStatisticsHandler;
import com.helger.statistics.api.IStatisticsHandlerCache;
import com.helger.statistics.api.IStatisticsHandlerCounter;
import com.helger.statistics.api.IStatisticsHandlerKeyedCounter;
import com.helger.statistics.api.IStatisticsHandlerKeyedSize;
import com.helger.statistics.api.IStatisticsHandlerKeyedTimer;
import com.helger.statistics.api.IStatisticsHandlerSize;
import com.helger.statistics.api.IStatisticsHandlerTimer;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.statistics.visit.IStatisticsVisitorCallback;
import jakarta.annotation.Nonnull;
import java.util.Comparator;

@Immutable
public final class StatisticsVisitor {
    private static final StatisticsVisitor INSTANCE = new StatisticsVisitor();

    private StatisticsVisitor() {
    }

    public static void visitStatistics(@Nonnull IStatisticsVisitorCallback iStatisticsVisitorCallback) {
        IStatisticsHandler iStatisticsHandler;
        ValueEnforcer.notNull((Object)iStatisticsVisitorCallback, (String)"Callback");
        ICommonsList iCommonsList = StatisticsManager.getAllCacheHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getCacheHandler(string);
            iStatisticsVisitorCallback.onCache(string, (IStatisticsHandlerCache)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllTimerHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getTimerHandler(string);
            iStatisticsVisitorCallback.onTimer(string, (IStatisticsHandlerTimer)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedTimerHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedTimerHandler(string);
            iStatisticsVisitorCallback.onKeyedTimer(string, (IStatisticsHandlerKeyedTimer)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllSizeHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getSizeHandler(string);
            iStatisticsVisitorCallback.onSize(string, (IStatisticsHandlerSize)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedSizeHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedSizeHandler(string);
            iStatisticsVisitorCallback.onKeyedSize(string, (IStatisticsHandlerKeyedSize)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllCounterHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getCounterHandler(string);
            iStatisticsVisitorCallback.onCounter(string, (IStatisticsHandlerCounter)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedCounterHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedCounterHandler(string);
            iStatisticsVisitorCallback.onKeyedCounter(string, (IStatisticsHandlerKeyedCounter)iStatisticsHandler);
        }
    }
}

