/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.factory;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.settings.ISettings;
import com.helger.settings.Settings;
import com.helger.settings.SettingsWithDefault;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public interface ISettingsFactory<T extends ISettings>
extends Function<String, T> {
    @Override
    public @NonNull T apply(@NonNull @Nonempty String var1);

    public static @NonNull ISettingsFactory<Settings> newInstance() {
        return Settings::new;
    }

    public static @NonNull ISettingsFactory<SettingsWithDefault> newInstance(@NonNull ISettings iSettings) {
        ValueEnforcer.notNull((Object)iSettings, (String)"DefaultSettings");
        return string -> new SettingsWithDefault(string, iSettings);
    }
}

