/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.json;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.collection.helper.CollectionSort;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonReader;
import com.helger.json.serialize.JsonWriter;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.settings.ISettings;
import com.helger.settings.exchange.ISettingsPersistence;
import com.helger.settings.factory.ISettingsFactory;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsPersistenceJson
implements ISettingsPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsPersistenceJson.class);
    private final ISettingsFactory<?> m_aSettingsFactory;
    private Charset m_aCharset = JsonReader.DEFAULT_CHARSET;

    public SettingsPersistenceJson() {
        this(ISettingsFactory.newInstance());
    }

    public SettingsPersistenceJson(@Nonnull ISettingsFactory<?> iSettingsFactory) {
        this.m_aSettingsFactory = (ISettingsFactory)ValueEnforcer.notNull(iSettingsFactory, (String)"SettingsFactory");
    }

    @Override
    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final SettingsPersistenceJson setCharset(@Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        this.m_aCharset = charset;
        return this;
    }

    @Nonnull
    public final ISettingsFactory<?> getSettingsFactory() {
        return this.m_aSettingsFactory;
    }

    @Nonnull
    @Nonempty
    protected String getReadSettingsName() {
        return "anonymous";
    }

    private static void _recursiveReadSettings(@Nonnull String string, @Nonnull IJson iJson, @Nonnull ISettings iSettings) {
        if (iJson.isValue()) {
            iSettings.putIn(string, iJson.getAsValue().getAsString());
        } else if (iJson.isObject()) {
            for (Map.Entry entry : iJson.getAsObject()) {
                SettingsPersistenceJson._recursiveReadSettings(string + "." + (String)entry.getKey(), (IJson)entry.getValue(), iSettings);
            }
        } else {
            throw new IllegalArgumentException("JSON arrays are not supported in settings");
        }
    }

    @Override
    @Nonnull
    public ISettings readSettings(@Nonnull @WillClose InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        Object obj = this.m_aSettingsFactory.apply(this.getReadSettingsName());
        IJsonObject iJsonObject = JsonReader.builder().source(inputStream, this.m_aCharset).requireStringQuotes(false).alwaysUseBigNumber(true).readAsObject();
        if (iJsonObject != null) {
            for (Map.Entry entry : iJsonObject) {
                SettingsPersistenceJson._recursiveReadSettings((String)entry.getKey(), (IJson)entry.getValue(), obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess writeSettings(@Nonnull ISettings iSettings, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            Map.Entry entry2;
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry2 : CollectionSort.getSorted((Collection)iSettings.entrySet(), Comparator.comparing(Map.Entry::getKey))) {
                String string = (String)entry2.getKey();
                Object v = entry2.getValue();
                String string2 = (String)TypeConverter.convert(v, String.class);
                jsonObject.add((Object)string, (Object)string2);
            }
            Iterator iterator = new JsonWriterSettings();
            iterator.setIndentEnabled(true);
            iterator.setQuoteNames(false);
            new JsonWriter((IJsonWriterSettings)iterator).writeToWriterAndClose((IJson)jsonObject, (Writer)StreamHelper.createWriter((OutputStream)outputStream, (Charset)this.m_aCharset));
            entry2 = ESuccess.SUCCESS;
            return entry2;
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write settings to JSON file", (Throwable)iOException);
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }
}

