/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.settings.ISettings;
import com.helger.typeconvert.collection.AttributeContainerAny;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@NotThreadSafe
public class Settings
extends AttributeContainerAny<String>
implements ISettings {
    private final String m_sName;

    public Settings(@Nonnull @Nonempty String string) {
        this.m_sName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
    }

    public Settings(@Nonnull ISettings iSettings) {
        this(iSettings.getName());
        this.putAllIn((Map)((Object)iSettings));
    }

    @Nonnull
    public EChange putIn(@Nonnull @Nonempty String string, @Nullable Object object) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        return super.putIn((Object)string, object);
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Settings settings = (Settings)object;
        return this.m_sName.equals(settings.m_sName);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sName).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Name", (Object)this.m_sName).getToString();
    }
}

