/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange;

import com.helger.annotation.WillClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.stream.StringInputStream;
import com.helger.base.state.ESuccess;
import com.helger.io.file.FileHelper;
import com.helger.settings.ISettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public interface ISettingsPersistence {
    @Nonnull
    public Charset getCharset();

    @Nonnull
    default public ISettings readSettings(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Settings");
        return this.readSettings((InputStream)new StringInputStream(string, this.getCharset()));
    }

    @Nonnull
    default public ISettings readSettings(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return this.readSettings(FileHelper.getInputStream((File)file));
    }

    @Nonnull
    default public ISettings readSettings(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            throw new IllegalArgumentException("Failed to open the provided input stream for the settings: " + String.valueOf(iHasInputStream));
        }
        return this.readSettings(inputStream);
    }

    @Nullable
    public ISettings readSettings(@Nonnull @WillClose InputStream var1);

    @Nullable
    default public String writeSettings(@Nonnull ISettings iSettings) {
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        if (this.writeSettings(iSettings, (OutputStream)nonBlockingByteArrayOutputStream).isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream.getAsString(this.getCharset());
    }

    @Nonnull
    default public ESuccess writeSettings(@Nonnull ISettings iSettings, @Nonnull File file) {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);
        if (fileOutputStream == null) {
            throw new IllegalArgumentException("Failed to open file '" + file.getAbsolutePath() + "' for writing!");
        }
        return this.writeSettings(iSettings, fileOutputStream);
    }

    @Nonnull
    public ESuccess writeSettings(@Nonnull ISettings var1, @Nonnull @WillClose OutputStream var2);
}

