/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.crl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.impl.Cache;
import com.helger.datetime.expiration.ExpiringObject;
import com.helger.security.crl.CRLDownloader;
import java.security.cert.CRL;
import java.time.Duration;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLCache {
    public static final Duration DEFAULT_CACHING_DURATION = Duration.ofHours(24L);
    private static final Logger LOGGER = LoggerFactory.getLogger(CRLCache.class);
    private final CRLInternalCache m_aCache;
    private final CRLDownloader m_aDownloader;
    private final Duration m_aCachingDuration;

    public CRLCache(@NonNull CRLDownloader cRLDownloader, @NonNull Duration duration) {
        ValueEnforcer.notNull((Object)cRLDownloader, (String)"CRLDownloader");
        ValueEnforcer.notNull((Object)duration, (String)"CachingDuration");
        ValueEnforcer.isFalse(duration::isNegative, (String)"CachingDuration must not be negative");
        this.m_aCache = new CRLInternalCache(string -> {
            CRL cRL = cRLDownloader.downloadCRL((String)string);
            return cRL == null ? null : ExpiringObject.ofDuration((Object)cRL, (Duration)duration);
        }, 200);
        this.m_aDownloader = cRLDownloader;
        this.m_aCachingDuration = duration;
    }

    public final @NonNull CRLDownloader getDownloader() {
        return this.m_aDownloader;
    }

    public final @NonNull Duration getCachingDuration() {
        return this.m_aCachingDuration;
    }

    public @Nullable CRL getCRLFromURL(@Nullable String string) {
        ExpiringObject expiringObject;
        if (StringHelper.isNotEmpty((String)string) && (expiringObject = (ExpiringObject)this.m_aCache.getFromCache(string)) != null) {
            if (expiringObject.isExpiredNow()) {
                LOGGER.info("The cached entry for CRL URL '" + string + "' is expired and needs to be re-fetched.");
                this.m_aCache.removeFromCache(string);
                ExpiringObject expiringObject2 = (ExpiringObject)this.m_aCache.getFromCache(string);
                if (expiringObject2 != null) {
                    return (CRL)expiringObject2.getObject();
                }
                LOGGER.warn("The re-fetch for CRL URL '" + string + "' was unsuccessful, so keeping the previous CRL version.");
                this.m_aCache._insertManually(string, (ExpiringObject<CRL>)ExpiringObject.ofDuration((Object)((CRL)expiringObject.getObject()), (Duration)this.m_aCachingDuration.dividedBy(2L)));
            }
            return (CRL)expiringObject.getObject();
        }
        return null;
    }

    public void setCRLOfURL(@NonNull @Nonempty String string, @NonNull CRL cRL) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CRLURL");
        ValueEnforcer.notNull((Object)cRL, (String)"CRL");
        this.m_aCache._insertManually(string, (ExpiringObject<CRL>)ExpiringObject.ofDuration((Object)cRL, (Duration)this.m_aCachingDuration));
    }

    public @NonNull EChange clearCache() {
        return this.m_aCache.clearCache();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Cache", (Object)this.m_aCache).append("Downloader", (Object)this.m_aDownloader).append("CachingDuration", (Object)this.m_aCachingDuration).getToString();
    }

    public static @NonNull CRLCache createDefault() {
        return new CRLCache(new CRLDownloader(), DEFAULT_CACHING_DURATION);
    }

    @ThreadSafe
    private static class CRLInternalCache
    extends Cache<String, ExpiringObject<CRL>> {
        public CRLInternalCache(@NonNull Function<String, ExpiringObject<CRL>> function, int n) {
            super(function, n, "CRLCache", true);
        }

        private void _insertManually(String string, ExpiringObject<CRL> expiringObject) {
            super.putInCache((Object)string, expiringObject);
        }
    }
}

