/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.certificate;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.codec.base64.Base64;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsSet;
import com.helger.security.certificate.CertificateDecodeHelper;
import com.helger.security.certificate.ECertificateCheckResult;
import com.helger.security.revocation.AbstractRevocationCheckBuilder;
import com.helger.security.revocation.RevocationCheckResultCache;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CertificateHelper {
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    public static final String CRLF = "\r\n";
    public static final Charset CERT_CHARSET = StandardCharsets.ISO_8859_1;
    public static final String PRINCIPAL_TYPE_C = "C";
    public static final String PRINCIPAL_TYPE_CN = "CN";
    public static final String PRINCIPAL_TYPE_O = "O";
    public static final String PRINCIPAL_TYPE_OU = "OU";
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateHelper.class);
    private static final CertificateHelper INSTANCE = new CertificateHelper();

    private CertificateHelper() {
    }

    public static @NonNull CertificateFactory getX509CertificateFactory() throws CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    public static @NonNull String getCertificateWithPEMHeader(@NonNull String string) {
        Object object = string;
        if (!((String)object).startsWith(BEGIN_CERTIFICATE)) {
            object = "-----BEGIN CERTIFICATE-----\n" + (String)object;
        }
        if (!((String)object).trim().endsWith(END_CERTIFICATE)) {
            object = (String)object + "\n-----END CERTIFICATE-----";
        }
        return object;
    }

    public static @Nullable String getWithoutPEMHeader(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        String string2 = string.trim();
        string2 = StringHelper.trimStart((String)string2, (String)BEGIN_CERTIFICATE);
        string2 = StringHelper.trimEnd((String)string2, (String)END_CERTIFICATE);
        return StringHelper.getWithoutAnySpaces((String)string2);
    }

    public static @Nullable String getRFC1421CompliantString(@Nullable String string, boolean bl) {
        return CertificateHelper.getRFC1421CompliantString(string, bl, CRLF);
    }

    public static @Nullable String getRFC1421CompliantString(@Nullable String string, boolean bl, @NonNull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"LineSeparator");
        String string3 = CertificateHelper.getWithoutPEMHeader(string);
        if (StringHelper.isEmpty((String)string3)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(BEGIN_CERTIFICATE).append('\n');
        }
        while (string3.length() > 64) {
            stringBuilder.append(string3, 0, 64).append(string2);
            string3 = string3.substring(64);
        }
        stringBuilder.append(string3);
        if (bl) {
            stringBuilder.append('\n').append(END_CERTIFICATE);
        }
        return stringBuilder.toString();
    }

    @Deprecated(forRemoval=true, since="12.1.1")
    public static @Nullable X509Certificate convertByteArrayToCertficate(byte @Nullable [] byArray) throws CertificateException {
        return new CertificateDecodeHelper().source(byArray).pemEncoded(true).getDecodedOrThrow();
    }

    @Deprecated(forRemoval=true, since="12.1.1")
    public static @Nullable X509Certificate convertByteArrayToCertficateOrNull(byte @Nullable [] byArray) {
        return new CertificateDecodeHelper().source(byArray).pemEncoded(true).getDecodedOrNull();
    }

    @Deprecated(forRemoval=true, since="12.1.1")
    public static @Nullable X509Certificate convertByteArrayToCertficateDirect(byte @Nullable [] byArray) throws CertificateException {
        return new CertificateDecodeHelper().source(byArray).pemEncoded(false).getDecodedOrThrow();
    }

    @Deprecated(forRemoval=true, since="12.1.1")
    public static @Nullable X509Certificate convertStringToCertficate(@Nullable String string) throws CertificateException {
        return new CertificateDecodeHelper().source(string).pemEncoded(true).getDecodedOrThrow();
    }

    @Deprecated(forRemoval=true, since="12.1.1")
    public static @Nullable X509Certificate convertStringToCertficateOrNull(@Nullable String string) {
        return new CertificateDecodeHelper().source(string).pemEncoded(true).getDecodedOrNull();
    }

    public static byte @Nullable [] convertCertificateStringToByteArray(@Nullable String string) {
        String string2 = CertificateHelper.getWithoutPEMHeader(string);
        if (StringHelper.isEmpty((String)string2)) {
            return null;
        }
        return Base64.safeDecode((String)string2);
    }

    public static byte @NonNull @Nonempty [] getEncodedCertificate(@NonNull Certificate certificate) {
        ValueEnforcer.notNull((Object)certificate, (String)"Cert");
        try {
            return certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("Failed to encode certificate " + String.valueOf(certificate), certificateEncodingException);
        }
    }

    public static @NonNull @Nonempty String getPEMEncodedCertificate(@NonNull Certificate certificate) {
        ValueEnforcer.notNull((Object)certificate, (String)"Cert");
        try {
            String string = Base64.encodeBytes((byte[])certificate.getEncoded());
            return "-----BEGIN CERTIFICATE-----\n" + string + "\n-----END CERTIFICATE-----";
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("Failed to encode certificate " + String.valueOf(certificate), certificateEncodingException);
        }
    }

    public static boolean isCertificateValidPerNow(@NonNull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        try {
            x509Certificate.checkValidity();
            return true;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
            return false;
        }
    }

    public static @Nullable PrivateKey convertStringToPrivateKey(@Nullable String string) throws GeneralSecurityException {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        String string2 = StringHelper.trimStart((String)string, (String)BEGIN_PRIVATE_KEY);
        string2 = StringHelper.trimEnd((String)string2, (String)END_PRIVATE_KEY);
        byte[] byArray = Base64.safeDecode((String)(string2 = StringHelper.getWithoutAnySpaces((String)string2)));
        if (byArray == null) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    public static boolean isCA(@NonNull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        byte[] byArray = x509Certificate.getExtensionValue(Extension.basicConstraints.getId());
        if (byArray != null) {
            try {
                ASN1Sequence aSN1Sequence;
                BasicConstraints basicConstraints;
                ASN1Primitive aSN1Primitive = JcaX509ExtensionUtils.parseExtensionValue((byte[])byArray);
                if (aSN1Primitive instanceof ASN1Sequence && (basicConstraints = BasicConstraints.getInstance((Object)(aSN1Sequence = (ASN1Sequence)aSN1Primitive))) != null) {
                    return basicConstraints.isCA();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static @NonNull ECertificateCheckResult checkCertificate(@Nullable ICommonsSet<X500Principal> iCommonsSet, @Nullable RevocationCheckResultCache revocationCheckResultCache, @NonNull AbstractRevocationCheckBuilder<?> abstractRevocationCheckBuilder) {
        X509Certificate x509Certificate;
        ValueEnforcer.notNull(abstractRevocationCheckBuilder, (String)"RevocationChecker");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Running Certificate Check" + (String)(iCommonsSet != null ? " against a list of " + iCommonsSet.size() + " certificate issuers" : "") + (revocationCheckResultCache != null ? "; a cache is provided" : "; not using a cache"));
        }
        if ((x509Certificate = abstractRevocationCheckBuilder.certificate()) == null) {
            LOGGER.warn("No Certificate was provided to the certificate check");
            return ECertificateCheckResult.NO_CERTIFICATE_PROVIDED;
        }
        Date date = abstractRevocationCheckBuilder.checkDate();
        try {
            if (date == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking the Certificate validity against the current date time");
                }
                x509Certificate.checkValidity();
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking the Certificate validity against the provided date time " + String.valueOf(date));
                }
                x509Certificate.checkValidity(date);
            }
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            LOGGER.warn("The provided Certificate is not yet valid per " + (date == null ? "now" : date.toString()));
            return ECertificateCheckResult.NOT_YET_VALID;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            LOGGER.warn("The provided Certificate is expired per " + (date == null ? "now" : date.toString()));
            return ECertificateCheckResult.EXPIRED;
        }
        if (iCommonsSet != null) {
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            if (!iCommonsSet.contains((Object)x500Principal)) {
                LOGGER.warn("The provided Certificate issuer '" + String.valueOf(x500Principal) + "' is not in the list of trusted issuers " + String.valueOf(iCommonsSet));
                return ECertificateCheckResult.UNSUPPORTED_ISSUER;
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Not testing against known Certificate issuers");
        }
        if (revocationCheckResultCache != null) {
            boolean bl;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing if the Certificate is revoked, using a cache");
            }
            if (bl = revocationCheckResultCache.isRevoked(x509Certificate)) {
                LOGGER.warn("The Certificate is revoked [caching used]");
                return ECertificateCheckResult.REVOKED;
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing if the Certificate is revoked, without a cache");
            }
            if (abstractRevocationCheckBuilder.build().isRevoked()) {
                LOGGER.warn("The Certificate is revoked [no caching]");
                return ECertificateCheckResult.REVOKED;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The Certificate seems to be valid");
        }
        return ECertificateCheckResult.VALID;
    }

    public static @Nullable String getPrincipalTypeValue(@Nullable String string, @NonNull String string2) throws InvalidNameException {
        ValueEnforcer.notNull((Object)string2, (String)"Type");
        if (string != null) {
            for (Rdn rdn : new LdapName(string).getRdns()) {
                if (!rdn.getType().equalsIgnoreCase(string2)) continue;
                return (String)rdn.getValue();
            }
        }
        return null;
    }

    public static @Nullable String getPrincipalTypeValueOrNull(@Nullable String string, @NonNull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"Type");
        try {
            return CertificateHelper.getPrincipalTypeValue(string, string2);
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }

    public static @Nullable String getPrincipalTypeValue(@Nullable X500Principal x500Principal, @NonNull String string) throws InvalidNameException {
        ValueEnforcer.notNull((Object)string, (String)"Type");
        if (x500Principal == null) {
            return null;
        }
        return CertificateHelper.getPrincipalTypeValue(x500Principal.getName(), string);
    }

    public static @Nullable String getPrincipalTypeValueOrNull(@Nullable X500Principal x500Principal, @NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Type");
        try {
            return CertificateHelper.getPrincipalTypeValue(x500Principal, string);
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }

    public static @Nullable String getCN(@Nullable String string) throws InvalidNameException {
        return CertificateHelper.getPrincipalTypeValue(string, PRINCIPAL_TYPE_CN);
    }

    public static @Nullable String getCNOrNull(@Nullable String string) {
        return CertificateHelper.getPrincipalTypeValueOrNull(string, PRINCIPAL_TYPE_CN);
    }

    public static @Nullable String getCNOrNull(@Nullable X500Principal x500Principal) {
        return CertificateHelper.getPrincipalTypeValueOrNull(x500Principal, PRINCIPAL_TYPE_CN);
    }

    public static @Nullable String getSubjectCN(@Nullable X509Certificate x509Certificate) {
        return x509Certificate != null ? CertificateHelper.getCNOrNull(x509Certificate.getSubjectX500Principal()) : null;
    }

    public static @Nullable String getO(@Nullable String string) throws InvalidNameException {
        return CertificateHelper.getPrincipalTypeValue(string, PRINCIPAL_TYPE_O);
    }

    public static @Nullable String getOOrNull(@Nullable String string) {
        return CertificateHelper.getPrincipalTypeValueOrNull(string, PRINCIPAL_TYPE_O);
    }

    public static @Nullable String getOOrNull(@Nullable X500Principal x500Principal) {
        return CertificateHelper.getPrincipalTypeValueOrNull(x500Principal, PRINCIPAL_TYPE_O);
    }

    public static @Nullable String getSubjectO(@Nullable X509Certificate x509Certificate) {
        return x509Certificate != null ? CertificateHelper.getOOrNull(x509Certificate.getSubjectX500Principal()) : null;
    }
}

