/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.EnumHelper;
import com.helger.security.keystore.IKeyStoreType;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum EKeyStoreType implements IKeyStoreType
{
    JKS("JKS", true),
    PKCS11("PKCS11", false),
    PKCS12("PKCS12", true),
    BKS("BKS", true),
    BCFKS("BCFKS", true);

    private final String m_sID;
    private final boolean m_bKeyStorePathRequired;

    private EKeyStoreType(String string2, boolean bl) {
        this.m_sID = string2;
        this.m_bKeyStorePathRequired = bl;
    }

    public @NonNull @Nonempty String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isKeyStorePathRequired() {
        return this.m_bKeyStorePathRequired;
    }

    public static @Nullable EKeyStoreType getFromIDOrNull(@Nullable String string) {
        return (EKeyStoreType)EnumHelper.getFromIDOrNull(EKeyStoreType.class, (Object)string);
    }

    public static @Nullable EKeyStoreType getFromIDCaseInsensitiveOrNull(@Nullable String string) {
        return (EKeyStoreType)EnumHelper.getFromIDCaseInsensitiveOrNull(EKeyStoreType.class, (String)string);
    }

    public static @Nullable EKeyStoreType getFromIDCaseInsensitiveOrDefault(@Nullable String string, @Nullable EKeyStoreType eKeyStoreType) {
        return (EKeyStoreType)EnumHelper.getFromIDCaseInsensitiveOrDefault(EKeyStoreType.class, (String)string, (Enum)eKeyStoreType);
    }
}

