/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHex;
import com.helger.security.random.VerySecureRandom;
import org.jspecify.annotations.NonNull;

@Immutable
public final class AuthTokenIDGenerator {
    public static final int DEFAULT_TOKEN_BYTES = 16;

    private AuthTokenIDGenerator() {
    }

    public static @NonNull String generateNewTokenID() {
        return AuthTokenIDGenerator.generateNewTokenID(16);
    }

    public static @NonNull String generateNewTokenID(@Nonnegative int n) {
        byte[] byArray = new byte[n];
        VerySecureRandom.getInstance().nextBytes(byArray);
        return StringHex.getHexEncoded((byte[])byArray);
    }
}

