/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.security.password.hash.AbstractPasswordHashCreator;
import com.helger.security.password.salt.IPasswordSalt;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;

public final class PasswordHashCreatorSHA512
extends AbstractPasswordHashCreator {
    public static final EMessageDigestAlgorithm MESSAGE_DIGEST_ALGO = EMessageDigestAlgorithm.SHA_512;
    public static final String ALGORITHM = MESSAGE_DIGEST_ALGO.getAlgorithm();

    public PasswordHashCreatorSHA512() {
        super(ALGORITHM);
    }

    @Override
    public boolean requiresSalt() {
        return false;
    }

    @Override
    @Nonnull
    public String createPasswordHash(@Nullable IPasswordSalt iPasswordSalt, @Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"PlainTextPassword");
        return MessageDigestValue.create(string.getBytes(StandardCharsets.UTF_8), MESSAGE_DIGEST_ALGO).getHexEncodedDigestString();
    }
}

