/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.certificate;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsSet;
import com.helger.security.certificate.CertificateHelper;
import jakarta.annotation.Nonnull;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TrustedCACertificates {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustedCACertificates.class);
    private final ICommonsList<X509Certificate> m_aCerts = new CommonsArrayList();
    private final ICommonsSet<X500Principal> m_aIssuers = new CommonsHashSet();

    public TrustedCACertificates() {
    }

    public TrustedCACertificates(@Nonnull TrustedCACertificates trustedCACertificates) {
        ValueEnforcer.notNull((Object)trustedCACertificates, (String)"Src");
        this.m_aCerts.addAll(trustedCACertificates.m_aCerts);
        this.m_aIssuers.addAll(trustedCACertificates.m_aIssuers);
    }

    public void addTrustedCACertificate(@Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Certificate");
        if (!CertificateHelper.isCA(x509Certificate)) {
            throw new IllegalArgumentException("The provided certificate does not seem to be a CA: " + String.valueOf(x509Certificate));
        }
        if (this.m_aCerts.contains((Object)x509Certificate)) {
            throw new IllegalArgumentException("Certificate is already trusted as a CA: " + String.valueOf(x509Certificate));
        }
        this.m_aCerts.add((Object)x509Certificate);
        this.m_aIssuers.add((Object)x509Certificate.getSubjectX500Principal());
    }

    public void clearTrustedCACertificates() {
        if (!this.m_aCerts.isEmpty()) {
            LOGGER.warn("Explicitly removing all " + this.m_aCerts.size() + " entries from the list of trusted CA certificates");
            this.m_aCerts.clear();
            this.m_aIssuers.clear();
        }
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<X509Certificate> getAllTrustedCACertificates() {
        return (ICommonsList)this.m_aCerts.getClone();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsSet<X500Principal> getAllTrustedCAIssuers() {
        return (ICommonsSet)this.m_aIssuers.getClone();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Certs#", this.m_aCerts.size()).append("Issuers", this.m_aIssuers).getToString();
    }
}

