/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.mac;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.WrappedOutputStream;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Mac;

public class MacOutputStream
extends WrappedOutputStream {
    public static final boolean DEFAULT_ON = true;
    private Mac m_aMac;
    private boolean m_bOn = true;

    public MacOutputStream(@Nonnull OutputStream outputStream, @Nonnull Mac mac) {
        super(outputStream);
        this.setMac(mac);
    }

    @Nonnull
    public final Mac getMac() {
        return this.m_aMac;
    }

    public final void setMac(@Nonnull Mac mac) {
        ValueEnforcer.notNull((Object)mac, (String)"Mac");
        this.m_aMac = mac;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        if (this.m_bOn) {
            this.m_aMac.update((byte)n);
        }
    }

    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this.out.write(byArray, n, n2);
        if (this.m_bOn) {
            this.m_aMac.update(byArray, n, n2);
        }
    }

    public final void setOn(boolean bl) {
        this.m_bOn = bl;
    }

    public final boolean isOn() {
        return this.m_bOn;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Mac", (Object)this.m_aMac).append("On", this.m_bOn).getToString();
    }
}

