/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.certificate;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.state.IValidityIndicator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum ECertificateCheckResult implements IHasID<String>,
IValidityIndicator
{
    VALID("valid", "certificate is valid"),
    NO_CERTIFICATE_PROVIDED("nocert", "no certificate provided"),
    NOT_YET_VALID("notyetvalid", "certificate is not yet valid"),
    EXPIRED("expired", "certificate is already expired"),
    UNSUPPORTED_ISSUER("unsupportedissuer", "unsupported certificate issuer"),
    REVOKED("revoked", "certificate is revoked"),
    NOT_CHECKED("not-checked", "the certificate was not checked");

    private final String m_sID;
    private final String m_sReason;

    private ECertificateCheckResult(String string2, String string3) {
        this.m_sID = string2;
        this.m_sReason = string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getReason() {
        return this.m_sReason;
    }

    public boolean isValid() {
        return this == VALID;
    }

    @Nullable
    public static ECertificateCheckResult getFromIDOrNull(@Nullable String string) {
        return (ECertificateCheckResult)EnumHelper.getFromIDOrNull(ECertificateCheckResult.class, (Object)string);
    }

    @Nullable
    public static ECertificateCheckResult getFromIDOrDefault(@Nullable String string, @Nullable ECertificateCheckResult eCertificateCheckResult) {
        return (ECertificateCheckResult)EnumHelper.getFromIDOrDefault(ECertificateCheckResult.class, (Object)string, (Enum)eCertificateCheckResult);
    }
}

