/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHex;
import com.helger.security.random.VerySecureRandom;
import jakarta.annotation.Nonnull;

@Immutable
public final class AuthTokenIDGenerator {
    public static final int DEFAULT_TOKEN_BYTES = 16;

    private AuthTokenIDGenerator() {
    }

    @Nonnull
    public static String generateNewTokenID() {
        return AuthTokenIDGenerator.generateNewTokenID(16);
    }

    @Nonnull
    public static String generateNewTokenID(@Nonnegative int n) {
        byte[] byArray = new byte[n];
        VerySecureRandom.getInstance().nextBytes(byArray);
        return StringHex.getHexEncoded((byte[])byArray);
    }
}

