/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.security.keystore.EKeyStoreLoadErrorText;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EKeyStoreLoadError implements IHasID<String>,
IHasDisplayTextWithArgs
{
    KEYSTORE_NO_PATH("keystore-no-path", EKeyStoreLoadErrorText.KEYSTORE_NO_PATH),
    KEYSTORE_LOAD_ERROR_NON_EXISTING("keystore-load-error-non-existing", EKeyStoreLoadErrorText.KEYSTORE_LOAD_ERROR_NON_EXISTING),
    KEYSTORE_INVALID_PASSWORD("keystore-invalid-password", EKeyStoreLoadErrorText.KEYSTORE_INVALID_PASSWORD),
    KEYSTORE_LOAD_ERROR_FORMAT_ERROR("keystore-load-error-format-error", EKeyStoreLoadErrorText.KEYSTORE_LOAD_ERROR_FORMAT_ERROR),
    KEY_NO_ALIAS("key-no-alias", EKeyStoreLoadErrorText.KEY_NO_ALIAS),
    KEY_NO_PASSWORD("key-no-password", EKeyStoreLoadErrorText.KEY_NO_PASSWORD),
    KEY_INVALID_ALIAS("key-invalid-alias", EKeyStoreLoadErrorText.KEY_INVALID_ALIAS),
    KEY_INVALID_TYPE("key-invalid-type", EKeyStoreLoadErrorText.KEY_INVALID_TYPE),
    KEY_INVALID_PASSWORD("key-invalid-password", EKeyStoreLoadErrorText.KEY_INVALID_PASSWORD),
    KEY_LOAD_ERROR("key-load-error", EKeyStoreLoadErrorText.KEY_LOAD_ERROR);

    private final String m_sID;
    private final EKeyStoreLoadErrorText m_aDisplayText;

    private EKeyStoreLoadError(String string2, EKeyStoreLoadErrorText eKeyStoreLoadErrorText) {
        this.m_sID = string2;
        this.m_aDisplayText = eKeyStoreLoadErrorText;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aDisplayText.getDisplayText(locale);
    }
}

