/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.util.TextHelper;
import com.helger.security.keystore.EKeyStoreLoadError;
import java.security.KeyStore;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoadedKeyStore
implements ISuccessIndicator {
    private final KeyStore m_aKeyStore;
    private final EKeyStoreLoadError m_eError;
    private final String[] m_aErrorParams;

    public LoadedKeyStore(@Nullable KeyStore keyStore, @Nullable EKeyStoreLoadError eKeyStoreLoadError, String ... stringArray) {
        this.m_aKeyStore = keyStore;
        this.m_eError = eKeyStoreLoadError;
        this.m_aErrorParams = stringArray;
    }

    public boolean isSuccess() {
        return this.m_aKeyStore != null;
    }

    @Nullable
    public KeyStore getKeyStore() {
        return this.m_aKeyStore;
    }

    @Nullable
    public EKeyStoreLoadError getError() {
        return this.m_eError;
    }

    @Nullable
    public String[] getErrorParams() {
        return this.m_eError == null ? null : (String[])ArrayHelper.getCopy((Object[])this.m_aErrorParams);
    }

    @Nullable
    public String getErrorText(@Nonnull Locale locale) {
        return this.m_eError == null ? null : this.m_eError.getDisplayTextWithArgs(locale, this.m_aErrorParams);
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKeyStore loadedKeyStore) {
        return loadedKeyStore == null ? null : loadedKeyStore.getErrorText(TextHelper.EN);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("KeyStore", (Object)this.m_aKeyStore).append("Error", (Enum)this.m_eError).append("ErrorParams", (Object[])this.m_aErrorParams).getToString();
    }
}

