/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.crl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CRLHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRLHelper.class);

    private CRLHelper() {
    }

    @Nonnull
    public static X509CRL convertToCRL(@Nonnull @Nonempty byte[] byArray) {
        X509CRL x509CRL;
        ValueEnforcer.notEmpty((byte[])byArray, (String)"CRLBytes");
        NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            x509CRL = (X509CRL)certificateFactory.generateCRL((InputStream)nonBlockingByteArrayInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    nonBlockingByteArrayInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (CertificateException certificateException) {
                throw new IllegalArgumentException(certificateException);
            }
            catch (CRLException cRLException) {
                throw new IllegalArgumentException("Cannot generate X.509 CRL from the stream data", cRLException);
            }
        }
        nonBlockingByteArrayInputStream.close();
        return x509CRL;
    }

    @Nonnull
    public static ICommonsList<String> getAllDistributionPoints(@Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Certificate");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        byte[] byArray = x509Certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (byArray != null) {
            try (ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);){
                CRLDistPoint cRLDistPoint;
                try {
                    DistributionPoint[] distributionPointArray = (DistributionPoint[])aSN1InputStream.readObject();
                    try (ASN1InputStream aSN1InputStream2 = new ASN1InputStream(distributionPointArray.getOctets());){
                        ASN1Primitive aSN1Primitive = aSN1InputStream2.readObject();
                        cRLDistPoint = CRLDistPoint.getInstance((Object)aSN1Primitive);
                    }
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
                for (DistributionPoint distributionPoint : cRLDistPoint.getDistributionPoints()) {
                    GeneralName[] generalNameArray;
                    DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                    if (distributionPointName == null || distributionPointName.getType() != 0) continue;
                    for (GeneralName generalName : generalNameArray = GeneralNames.getInstance((Object)distributionPointName.getName()).getNames()) {
                        if (generalName.getTagNo() != 6) continue;
                        String string = ASN1IA5String.getInstance((Object)generalName.getName()).getString().trim();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Found CRL URL '" + string + "' in certificate");
                        }
                        commonsArrayList.add((Object)string);
                    }
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        return commonsArrayList;
    }
}

