/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.resourceprovider.ClassPathResourceProvider;
import com.helger.commons.io.resourceprovider.FileSystemResourceProvider;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringHelper;
import com.helger.security.keystore.EKeyStoreLoadError;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyStoreHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreHelper.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IReadableResourceProvider s_aResourceProvider = new ReadableResourceProviderChain(new IReadableResourceProvider[]{new FileSystemResourceProvider().setCanReadRelativePaths(true), new ClassPathResourceProvider()});
    private static final KeyStoreHelper INSTANCE = new KeyStoreHelper();

    private KeyStoreHelper() {
    }

    @Nonnull
    public static IReadableResourceProvider getResourceProvider() {
        return (IReadableResourceProvider)RW_LOCK.readLockedGet(() -> s_aResourceProvider);
    }

    public static void setResourceProvider(@Nonnull IReadableResourceProvider iReadableResourceProvider) {
        ValueEnforcer.notNull((Object)iReadableResourceProvider, (String)"ResourceProvider");
        RW_LOCK.writeLocked(() -> {
            s_aResourceProvider = iReadableResourceProvider;
        });
    }

    @Nonnull
    public static KeyStore getSimiliarKeyStore(@Nonnull KeyStore keyStore) throws KeyStoreException {
        ValueEnforcer.notNull((Object)keyStore, (String)"Other");
        return KeyStoreHelper.getSimiliarKeyStore(keyStore, null);
    }

    @Nonnull
    public static KeyStore getSimiliarKeyStore(@Nonnull KeyStore keyStore, @Nullable Provider provider) throws KeyStoreException {
        ValueEnforcer.notNull((Object)keyStore, (String)"Other");
        return KeyStore.getInstance(keyStore.getType(), provider != null ? provider : keyStore.getProvider());
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.1.9")
    public static KeyStore loadKeyStoreDirect(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable String string2) throws GeneralSecurityException, IOException {
        return KeyStoreHelper.loadKeyStoreDirect(iKeyStoreType, string, string2, null);
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.1.9")
    public static KeyStore loadKeyStoreDirect(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable String string2, @Nullable Provider provider) throws GeneralSecurityException, IOException {
        return KeyStoreHelper.loadKeyStoreDirect(iKeyStoreType, string, string2 == null ? null : string2.toCharArray(), provider);
    }

    @Nonnull
    public static KeyStore loadKeyStoreDirect(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable char[] cArray) throws GeneralSecurityException, IOException {
        return KeyStoreHelper.loadKeyStoreDirect(iKeyStoreType, string, cArray, null);
    }

    @Nonnull
    public static KeyStore loadKeyStoreDirect(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable char[] cArray, @Nullable Provider provider) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        InputStream inputStream;
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"KeyStoreType");
        if (iKeyStoreType.isKeyStorePathRequired()) {
            ValueEnforcer.notNull((Object)string, (String)"KeyStorePath");
            inputStream = KeyStoreHelper.getResourceProvider().getInputStream(string);
            if (inputStream == null) {
                throw new IllegalArgumentException("Failed to open key store '" + string + "'");
            }
        } else {
            inputStream = null;
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to load key store from path '" + string + "' using type " + (String)iKeyStoreType.getID());
            }
            KeyStore keyStore2 = provider != null ? iKeyStoreType.getKeyStore(provider) : iKeyStoreType.getKeyStore();
            keyStore2.load(inputStream, cArray);
            keyStore = keyStore2;
        }
        catch (KeyStoreException keyStoreException) {
            try {
                throw new IllegalStateException("No provider can handle key stores of type " + iKeyStoreType, keyStoreException);
            }
            catch (Throwable throwable) {
                StreamHelper.close(inputStream);
                throw throwable;
            }
        }
        StreamHelper.close((AutoCloseable)inputStream);
        return keyStore;
    }

    @Nonnull
    public static KeyStore createKeyStoreWithOnlyOneItem(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable char[] cArray) throws GeneralSecurityException, IOException {
        return KeyStoreHelper.createKeyStoreWithOnlyOneItem(keyStore, string, cArray, null);
    }

    @Nonnull
    public static KeyStore createKeyStoreWithOnlyOneItem(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable char[] cArray, @Nullable Provider provider) throws GeneralSecurityException, IOException {
        ValueEnforcer.notNull((Object)keyStore, (String)"BaseKeyStore");
        ValueEnforcer.notNull((Object)string, (String)"AliasToCopy");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create a new key store using type " + keyStore.getType());
        }
        KeyStore keyStore2 = KeyStoreHelper.getSimiliarKeyStore(keyStore, provider);
        keyStore2.load(null, null);
        KeyStore.PasswordProtection passwordProtection = null;
        if (cArray != null) {
            passwordProtection = new KeyStore.PasswordProtection(cArray);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Copying alias '" + string + "' from old key store to new key store");
        }
        keyStore2.setEntry(string, keyStore.getEntry(string, passwordProtection), passwordProtection);
        return keyStore2;
    }

    private static boolean _isInvalidPasswordException(@Nonnull Exception exception) {
        return exception instanceof IOException && exception.getCause() instanceof UnrecoverableKeyException;
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.1.9")
    public static LoadedKeyStore loadKeyStore(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable String string2) {
        return KeyStoreHelper.loadKeyStore(iKeyStoreType, string, string2, null);
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.1.9")
    public static LoadedKeyStore loadKeyStore(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable String string2, @Nullable Provider provider) {
        return KeyStoreHelper.loadKeyStore(iKeyStoreType, string, string2 == null ? null : string2.toCharArray(), null);
    }

    @Nonnull
    public static LoadedKeyStore loadKeyStore(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable char[] cArray) {
        return KeyStoreHelper.loadKeyStore(iKeyStoreType, string, cArray, null);
    }

    @Nonnull
    public static LoadedKeyStore loadKeyStore(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable char[] cArray, @Nullable Provider provider) {
        KeyStore keyStore;
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"KeyStoreType");
        if (iKeyStoreType.isKeyStorePathRequired() && StringHelper.hasNoText((String)string)) {
            return new LoadedKeyStore(null, EKeyStoreLoadError.KEYSTORE_NO_PATH, new String[0]);
        }
        try {
            keyStore = KeyStoreHelper.loadKeyStoreDirect(iKeyStoreType, string, cArray, provider);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn("No such key store '" + string + "': " + illegalArgumentException.getMessage(), illegalArgumentException.getCause());
            return new LoadedKeyStore(null, EKeyStoreLoadError.KEYSTORE_LOAD_ERROR_NON_EXISTING, string, illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            boolean bl = KeyStoreHelper._isInvalidPasswordException(exception);
            LOGGER.warn("Failed to load key store '" + string + "' of type " + (String)iKeyStoreType.getID() + ": " + exception.getMessage(), bl ? null : exception.getCause());
            return new LoadedKeyStore(null, bl ? EKeyStoreLoadError.KEYSTORE_INVALID_PASSWORD : EKeyStoreLoadError.KEYSTORE_LOAD_ERROR_FORMAT_ERROR, string, exception.getMessage());
        }
        return new LoadedKeyStore(keyStore, null, new String[0]);
    }

    @Nonnull
    private static <T extends KeyStore.Entry> LoadedKey<T> _loadKey(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable char[] cArray, @Nonnull Class<T> clazz) {
        KeyStore.Entry entry;
        ValueEnforcer.notNull((Object)keyStore, (String)"KeyStore");
        ValueEnforcer.notNull((Object)string, (String)"KeyStorePath");
        ValueEnforcer.notNull(clazz, (String)"TargetClass");
        if (StringHelper.hasNoText((String)string2)) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_NO_ALIAS, string);
        }
        if (cArray == null) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_NO_PASSWORD, string2, string);
        }
        try {
            KeyStore.PasswordProtection passwordProtection;
            KeyStore.Entry entry2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to access key store entry with alias '" + string2 + "' as a " + clazz.getName());
            }
            if ((entry2 = keyStore.getEntry(string2, passwordProtection = new KeyStore.PasswordProtection(cArray))) == null) {
                return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_ALIAS, string2, string);
            }
            if (!clazz.isAssignableFrom(entry2.getClass())) {
                return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_TYPE, string2, string, ClassHelper.getClassName((Object)entry2));
            }
            entry = (KeyStore.Entry)clazz.cast(entry2);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_PASSWORD, string2, string, unrecoverableKeyException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_LOAD_ERROR, string2, string, generalSecurityException.getMessage());
        }
        return new LoadedKey<KeyStore.Entry>(entry, null, new String[0]);
    }

    @Nonnull
    public static LoadedKey<KeyStore.PrivateKeyEntry> loadPrivateKey(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable char[] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.PrivateKeyEntry.class);
    }

    @Nonnull
    public static LoadedKey<KeyStore.SecretKeyEntry> loadSecretKey(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable char[] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.SecretKeyEntry.class);
    }

    @Nonnull
    public static LoadedKey<KeyStore.TrustedCertificateEntry> loadTrustedCertificateKey(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable char[] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.TrustedCertificateEntry.class);
    }
}

