/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.subject;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.authentication.subject.IAuthSubject;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AuthSubject
implements IAuthSubject {
    private final String m_sID;
    private final String m_sDisplayName;

    public AuthSubject(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_sDisplayName = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"DisplayName");
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public final String getDisplayName() {
        return this.m_sDisplayName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuthSubject authSubject = (AuthSubject)object;
        return this.m_sID.equals(authSubject.m_sID) && this.m_sDisplayName.equals(authSubject.m_sDisplayName);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Object)this.m_sDisplayName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("DisplayName", (Object)this.m_sDisplayName).getToString();
    }
}

