/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.credentials;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CredentialValidationResultList
implements ICredentialValidationResult {
    private final ICommonsList<ICredentialValidationResult> m_aResults;
    private final boolean m_bFailure;

    public CredentialValidationResultList(@Nonnull @Nonempty Iterable<? extends ICredentialValidationResult> iterable) {
        ValueEnforcer.notEmpty(iterable, (String)"Results");
        this.m_aResults = new CommonsArrayList(iterable);
        this.m_bFailure = this.m_aResults.containsAny(ISuccessIndicator::isFailure);
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ICredentialValidationResult> getResults() {
        return (ICommonsList)this.m_aResults.getClone();
    }

    public boolean isSuccess() {
        return !this.m_bFailure;
    }

    public boolean isFailure() {
        return this.m_bFailure;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return StringHelper.getImplodedMapped((char)'\n', this.m_aResults, iCredentialValidationResult -> iCredentialValidationResult.getDisplayText(locale));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Results", this.m_aResults).append("Failure", this.m_bFailure).getToString();
    }
}

