/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.singleton;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.scope.IScope;
import com.helger.scope.IScopeDestructionAware;
import com.helger.scope.singleton.SingletonHelper;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.impl.StatisticsManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.BitSet;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractSingleton
implements IScopeDestructionAware {
    private static final int STATUS_IN_INSTANTIATION = 0;
    private static final int STATUS_INSTANTIATED = 1;
    private static final int STATUS_IN_PRE_DESTRUCTION = 2;
    private static final int STATUS_IN_DESTRUCTION = 3;
    private static final int STATUS_DESTROYED = 4;
    private static final int DEFAULT_KEY_LENGTH = 255;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSingleton.class);
    private static final IMutableStatisticsHandlerKeyedCounter STATS_INSTANCE_COUNTER = StatisticsManager.getKeyedCounterHandler(AbstractSingleton.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private BitSet m_aStatus = new BitSet(16);

    protected final void writeAbstractSingletonFields(@NonNull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.m_aStatus);
    }

    protected final void readAbstractSingletonFields(@NonNull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_aStatus = (BitSet)objectInputStream.readObject();
    }

    @UsedViaReflection
    protected AbstractSingleton() {
        if (GlobalDebug.isDebugMode()) {
            boolean bl = false;
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                String string = stackTraceElement.getMethodName();
                if (string.equals("getSingleton")) {
                    bl = true;
                    break;
                }
                if (!stackTraceElement.getClassName().equals(ObjectInputStream.class.getName()) || !string.equals("readOrdinaryObject")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalStateException("You cannot instantiate the class " + this.getClass().getName() + " manually! Use the method getSingleton instead!");
            }
        }
    }

    @OverrideOnDemand
    protected void onAfterInstantiation(@NonNull IScope iScope) {
    }

    protected final void setInInstantiation(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(0, bl));
    }

    public final boolean isInInstantiation() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aStatus.get(0));
    }

    protected final void setInstantiated(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(1, bl));
    }

    public final boolean isInstantiated() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aStatus.get(1));
    }

    protected final void setInPreDestruction(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(2, bl));
    }

    public final boolean isInPreDestruction() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aStatus.get(2));
    }

    protected final void setInDestruction(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(3, bl));
    }

    public final boolean isInDestruction() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aStatus.get(3));
    }

    protected final void setDestroyed(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(4, bl));
    }

    public final boolean isDestroyed() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aStatus.get(4));
    }

    @OverrideOnDemand
    protected void onBeforeDestroy(@NonNull IScope iScope) throws Exception {
    }

    @Override
    public final void onBeforeScopeDestruction(@NonNull IScope iScope) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onBeforeScopeDestruction for '" + this.toString() + "' in scope " + iScope.toString());
        }
        if (this.isInInstantiation()) {
            LOGGER.warn("Object currently in instantiation is destroyed soon: " + this.toString());
        } else if (!this.isInstantiated()) {
            LOGGER.warn("Object not instantiated is destroyed soon: " + this.toString());
        }
        if (this.isInPreDestruction()) {
            LOGGER.error("Object already in pre destruction is destroyed soon again: " + this.toString());
        } else if (this.isInDestruction()) {
            LOGGER.error("Object already in destruction is destroyed soon again: " + this.toString());
        } else if (this.isDestroyed()) {
            LOGGER.error("Object already destroyed is destroyed soon again: " + this.toString());
        }
        this.setInPreDestruction(true);
        this.onBeforeDestroy(iScope);
    }

    @OverrideOnDemand
    protected void onDestroy(@NonNull IScope iScope) throws Exception {
    }

    @Override
    public final void onScopeDestruction(@NonNull IScope iScope) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onScopeDestruction for '" + this.toString() + "' in scope " + iScope.toString());
        }
        if (this.isInInstantiation()) {
            LOGGER.warn("Object currently in instantiation is now destroyed: " + this.toString());
        } else if (!this.isInstantiated()) {
            LOGGER.warn("Object not instantiated is now destroyed: " + this.toString());
        }
        if (!this.isInPreDestruction()) {
            LOGGER.error("Object should be in pre destruction phase but is not: " + this.toString());
        }
        if (this.isInDestruction()) {
            LOGGER.error("Object already in destruction is now destroyed again: " + this.toString());
        } else if (this.isDestroyed()) {
            LOGGER.error("Object already destroyed is now destroyed again: " + this.toString());
        }
        this.setInDestruction(true);
        this.setInPreDestruction(false);
        try {
            this.onDestroy(iScope);
        }
        finally {
            this.setDestroyed(true);
            this.setInDestruction(false);
        }
    }

    public final boolean isUsableObject() {
        return this.isInstantiated() && !this.isInDestruction() && !this.isDestroyed();
    }

    public static final @NonNull String getSingletonScopeKey(@NonNull Class<? extends AbstractSingleton> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return new StringBuilder(255).append("singleton.").append(clazz.getName()).toString();
    }

    public static final <T extends AbstractSingleton> @Nullable T getSingletonIfInstantiated(@Nullable IScope iScope, @NonNull Class<T> clazz) {
        AbstractSingleton abstractSingleton;
        String string;
        Object object;
        ValueEnforcer.notNull(clazz, (String)"Class");
        if (iScope != null && (object = RW_LOCK.readLockedGet(() -> AbstractSingleton.lambda$getSingletonIfInstantiated$10(iScope, string = AbstractSingleton.getSingletonScopeKey(clazz)))) != null && (abstractSingleton = (AbstractSingleton)clazz.cast(object)).isUsableObject()) {
            return (T)abstractSingleton;
        }
        return null;
    }

    public static final boolean isSingletonInstantiated(@Nullable IScope iScope, @NonNull Class<? extends AbstractSingleton> clazz) {
        return AbstractSingleton.getSingletonIfInstantiated(iScope, clazz) != null;
    }

    private static <T extends AbstractSingleton> @NonNull T _instantiateSingleton(@NonNull Class<T> clazz, @NonNull IScope iScope) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created singleton for '" + clazz.toString() + "' in scope " + iScope.toString());
            }
            if (!ClassHelper.isPublicClass(clazz)) {
                throw new IllegalStateException("Class " + clazz.toString() + " is not instancable!");
            }
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(IScope.class);
                return (T)((AbstractSingleton)constructor.newInstance(iScope));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor<T> constructor = clazz.getDeclaredConstructor(null);
                return (T)((AbstractSingleton)constructor.newInstance(null));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error instantiating singleton of class " + clazz.getName() + " in scope " + iScope.toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends AbstractSingleton> @NonNull T getSingleton(@NonNull IScope iScope, @NonNull Class<T> clazz) {
        AbstractSingleton abstractSingleton;
        block8: {
            ValueEnforcer.notNull((Object)iScope, (String)"aScope");
            ValueEnforcer.notNull(clazz, (String)"Class");
            String string = AbstractSingleton.getSingletonScopeKey(clazz);
            abstractSingleton = (AbstractSingleton)RW_LOCK.readLockedGet(() -> (AbstractSingleton)iScope.attrs().getCastedValue((Object)string));
            if (abstractSingleton == null || abstractSingleton.isInInstantiation()) {
                RW_LOCK.writeLock().lock();
                try {
                    abstractSingleton = (AbstractSingleton)iScope.attrs().getCastedValue((Object)string);
                    if (abstractSingleton != null) break block8;
                    abstractSingleton = AbstractSingleton._instantiateSingleton(clazz, iScope);
                    iScope.attrs().putIn((Object)string, (Object)abstractSingleton);
                    abstractSingleton.setInInstantiation(true);
                    try {
                        abstractSingleton.onAfterInstantiation(iScope);
                        abstractSingleton.setInstantiated(true);
                    }
                    finally {
                        abstractSingleton.setInInstantiation(false);
                    }
                    STATS_INSTANCE_COUNTER.increment(string);
                }
                finally {
                    RW_LOCK.writeLock().unlock();
                }
            }
        }
        if (SingletonHelper.isDebugConsistency() && !abstractSingleton.isUsableObject()) {
            LOGGER.warn("Singleton '" + clazz.getName() + "' is not usable - please check your calling order: " + abstractSingleton.toString(), SingletonHelper.getDebugStackTrace());
        }
        return (T)abstractSingleton;
    }

    @ReturnsMutableCopy
    public static final <T extends AbstractSingleton> @NonNull ICommonsList<T> getAllSingletons(@Nullable IScope iScope, @NonNull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, (String)"DesiredClass");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iScope != null) {
            for (Object e : iScope.attrs().values()) {
                if (e == null || !clazz.isAssignableFrom(e.getClass())) continue;
                commonsArrayList.add((Object)((AbstractSingleton)clazz.cast(e)));
            }
        }
        return commonsArrayList;
    }

    public @NonNull String toString() {
        return new ToStringGenerator((Object)this).append("Status", (Object)this.m_aStatus).getToString();
    }

    private static /* synthetic */ Object lambda$getSingletonIfInstantiated$10(IScope iScope, String string) {
        return iScope.attrs().get((Object)string);
    }
}

