/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.mgr;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.scope.IScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import com.helger.scope.spi.ScopeSPIManager;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.impl.StatisticsManager;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScopeSessionManager
extends AbstractGlobalSingleton {
    public static final boolean DEFAULT_DESTROY_ALL_SESSIONS_ON_SCOPE_END = true;
    public static final boolean DEFAULT_END_ALL_SESSIONS_ON_SCOPE_END = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeSessionManager.class);
    private static final IMutableStatisticsHandlerCounter STATS_UNIQUE_SESSIONS = StatisticsManager.getCounterHandler((String)(ScopeSessionManager.class.getName() + "$UNIQUE_SESSIONS"));
    private static ScopeSessionManager s_aInstance;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ISessionScope> m_aSessionScopes = new CommonsHashMap();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aSessionsInDestruction = new CommonsHashSet();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bDestroyAllSessionsOnScopeEnd = true;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bEndAllSessionsOnScopeEnd = true;

    @Deprecated
    @UsedViaReflection
    public ScopeSessionManager() {
    }

    public static @NonNull ScopeSessionManager getInstance() {
        ScopeSessionManager scopeSessionManager = s_aInstance;
        if (scopeSessionManager == null) {
            scopeSessionManager = s_aInstance = ScopeSessionManager.getGlobalSingleton(ScopeSessionManager.class);
        }
        return scopeSessionManager;
    }

    public @Nullable ISessionScope getSessionScopeOfID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (ISessionScope)this.m_aRWLock.readLockedGet(() -> (ISessionScope)this.m_aSessionScopes.get((Object)string));
    }

    public void onScopeBegin(@NonNull ISessionScope iSessionScope) {
        ValueEnforcer.notNull((Object)iSessionScope, (String)"SessionScope");
        String string = iSessionScope.getID();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aSessionScopes.put((Object)string, (Object)iSessionScope) != null) {
                LOGGER.error("Overwriting session scope with ID '" + string + "'");
            }
        });
        iSessionScope.initScope();
        ScopeSPIManager.getInstance().onSessionScopeBegin(iSessionScope);
        STATS_UNIQUE_SESSIONS.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScopeEnd(@NonNull ISessionScope iSessionScope) {
        String string;
        boolean bl;
        ValueEnforcer.notNull((Object)iSessionScope, (String)"SessionScope");
        if (iSessionScope.isValid() && (bl = this.m_aRWLock.writeLockedBoolean(() -> this.lambda$onScopeEnd$2(string = iSessionScope.getID(), iSessionScope)))) {
            try {
                ScopeSPIManager.getInstance().onSessionScopeEnd(iSessionScope);
                iSessionScope.destroyScope();
            }
            finally {
                this.m_aRWLock.writeLockedBoolean(() -> this.m_aSessionsInDestruction.remove((Object)string));
            }
        }
    }

    public boolean containsAnySession() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aSessionScopes.isNotEmpty());
    }

    @Nonnegative
    public int getSessionCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aSessionScopes.size());
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ISessionScope> getAllSessionScopes() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aSessionScopes.copyOfValues());
    }

    private void _checkIfAnySessionsExist() {
        if (this.containsAnySession()) {
            this.m_aRWLock.writeLocked(() -> {
                LOGGER.error("The following " + this.m_aSessionScopes.size() + " session scopes are left over: " + this.m_aSessionScopes.toString());
                this.m_aSessionScopes.clear();
            });
        }
    }

    public void destroyAllSessions() {
        for (ISessionScope iSessionScope : this.getAllSessionScopes()) {
            if (!iSessionScope.selfDestruct().isContinue()) continue;
            this.onScopeEnd(iSessionScope);
        }
        this._checkIfAnySessionsExist();
    }

    private void _endAllSessionScopes() {
        for (ISessionScope iSessionScope : this.getAllSessionScopes()) {
            this.onScopeEnd(iSessionScope);
        }
        this._checkIfAnySessionsExist();
    }

    public final boolean isDestroyAllSessionsOnScopeEnd() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bDestroyAllSessionsOnScopeEnd);
    }

    public final @NonNull EChange setDestroyAllSessionsOnScopeEnd(boolean bl) {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_bDestroyAllSessionsOnScopeEnd == bl) {
                return EChange.UNCHANGED;
            }
            this.m_bDestroyAllSessionsOnScopeEnd = bl;
            return EChange.CHANGED;
        });
    }

    public final boolean isEndAllSessionsOnScopeEnd() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bEndAllSessionsOnScopeEnd);
    }

    public final @NonNull EChange setEndAllSessionsOnScopeEnd(boolean bl) {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_bEndAllSessionsOnScopeEnd == bl) {
                return EChange.UNCHANGED;
            }
            this.m_bEndAllSessionsOnScopeEnd = bl;
            return EChange.CHANGED;
        });
    }

    @Override
    protected void onDestroy(@NonNull IScope iScope) {
        if (this.isDestroyAllSessionsOnScopeEnd()) {
            this.destroyAllSessions();
        } else if (this.isEndAllSessionsOnScopeEnd()) {
            this._endAllSessionScopes();
        }
        s_aInstance = null;
    }

    private /* synthetic */ boolean lambda$onScopeEnd$2(String string, ISessionScope iSessionScope) {
        boolean bl = false;
        if (this.m_aSessionsInDestruction.add((Object)string)) {
            ISessionScope iSessionScope2 = (ISessionScope)this.m_aSessionScopes.remove((Object)string);
            if (!EqualsHelper.identityEqual((Object)iSessionScope2, (Object)iSessionScope)) {
                LOGGER.error("Ending an unknown session with ID '" + string + "'");
                LOGGER.error("  Scope to be removed: " + String.valueOf(iSessionScope));
                LOGGER.error("  Removed scope:       " + String.valueOf(iSessionScope2));
            }
            bl = true;
        } else {
            LOGGER.info("Already destructing session '" + string + "'");
        }
        return bl;
    }
}

