/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.mgr;

import com.helger.scope.IScope;
import com.helger.scope.mgr.ScopeManager;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum EScope {
    GLOBAL,
    SESSION,
    REQUEST;


    public @NonNull IScope getScope() {
        return this.getScope(true);
    }

    public @Nullable IScope getScope(boolean bl) {
        return EScope.getScope(this, bl);
    }

    public static @Nullable IScope getScope(@NonNull EScope eScope, boolean bl) {
        switch (eScope.ordinal()) {
            case 0: {
                return bl ? ScopeManager.getGlobalScope() : ScopeManager.getGlobalScopeOrNull();
            }
            case 1: {
                return ScopeManager.getSessionScope(bl);
            }
            case 2: {
                return bl ? ScopeManager.getRequestScope() : ScopeManager.getRequestScopeOrNull();
            }
        }
        throw new IllegalArgumentException("Unknown scope: " + String.valueOf((Object)eScope));
    }
}

