/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.ClassHelper;
import com.helger.scope.AbstractScope;
import com.helger.scope.IGlobalScope;
import com.helger.scope.ScopeHelper;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GlobalScope
extends AbstractScope
implements IGlobalScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalScope.class);

    public GlobalScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeHelper.isDebugGlobalScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Created global scope '" + string + "'", ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.isDebugGlobalScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroying global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.isDebugGlobalScopeLifeCycle(LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroyed global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), ScopeHelper.getDebugStackTrace());
        }
    }
}

