/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.StringHelper;
import com.helger.scope.IScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import com.helger.scope.spi.ScopeSPIManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScopeSessionManager
extends AbstractGlobalSingleton {
    public static final boolean DEFAULT_DESTROY_ALL_SESSIONS_ON_SCOPE_END = true;
    public static final boolean DEFAULT_END_ALL_SESSIONS_ON_SCOPE_END = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeSessionManager.class);
    private static final IMutableStatisticsHandlerCounter STATS_UNIQUE_SESSIONS = StatisticsManager.getCounterHandler((String)(ScopeSessionManager.class.getName() + "$UNIQUE_SESSIONS"));
    private static ScopeSessionManager INSTANCE = null;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ISessionScope> m_aSessionScopes = new CommonsHashMap();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aSessionsInDestruction = new CommonsHashSet();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bDestroyAllSessionsOnScopeEnd = true;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bEndAllSessionsOnScopeEnd = true;

    @Deprecated
    @UsedViaReflection
    public ScopeSessionManager() {
    }

    @Nonnull
    public static ScopeSessionManager getInstance() {
        ScopeSessionManager scopeSessionManager = INSTANCE;
        if (scopeSessionManager == null) {
            scopeSessionManager = INSTANCE = ScopeSessionManager.getGlobalSingleton(ScopeSessionManager.class);
        }
        return scopeSessionManager;
    }

    @Nullable
    public ISessionScope getSessionScopeOfID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (ISessionScope)this.m_aRWLock.readLockedGet(() -> (ISessionScope)this.m_aSessionScopes.get((Object)string));
    }

    public void onScopeBegin(@Nonnull ISessionScope iSessionScope) {
        ValueEnforcer.notNull((Object)iSessionScope, (String)"SessionScope");
        String string = iSessionScope.getID();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aSessionScopes.put((Object)string, (Object)iSessionScope) != null) {
                LOGGER.error("Overwriting session scope with ID '" + string + "'");
            }
        });
        iSessionScope.initScope();
        ScopeSPIManager.getInstance().onSessionScopeBegin(iSessionScope);
        STATS_UNIQUE_SESSIONS.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScopeEnd(@Nonnull ISessionScope iSessionScope) {
        String string;
        boolean bl;
        ValueEnforcer.notNull((Object)iSessionScope, (String)"SessionScope");
        if (iSessionScope.isValid() && (bl = this.m_aRWLock.writeLockedBoolean(() -> this.lambda$onScopeEnd$2(string = iSessionScope.getID(), iSessionScope)))) {
            try {
                ScopeSPIManager.getInstance().onSessionScopeEnd(iSessionScope);
                iSessionScope.destroyScope();
            }
            finally {
                this.m_aRWLock.writeLockedBoolean(() -> this.m_aSessionsInDestruction.remove((Object)string));
            }
        }
    }

    public boolean containsAnySession() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aSessionScopes.isNotEmpty());
    }

    @Nonnegative
    public int getSessionCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aSessionScopes.size());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISessionScope> getAllSessionScopes() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aSessionScopes.copyOfValues());
    }

    private void _checkIfAnySessionsExist() {
        if (this.containsAnySession()) {
            this.m_aRWLock.writeLocked(() -> {
                LOGGER.error("The following " + this.m_aSessionScopes.size() + " session scopes are left over: " + this.m_aSessionScopes.toString());
                this.m_aSessionScopes.clear();
            });
        }
    }

    public void destroyAllSessions() {
        for (ISessionScope iSessionScope : this.getAllSessionScopes()) {
            if (!iSessionScope.selfDestruct().isContinue()) continue;
            this.onScopeEnd(iSessionScope);
        }
        this._checkIfAnySessionsExist();
    }

    private void _endAllSessionScopes() {
        for (ISessionScope iSessionScope : this.getAllSessionScopes()) {
            this.onScopeEnd(iSessionScope);
        }
        this._checkIfAnySessionsExist();
    }

    public final boolean isDestroyAllSessionsOnScopeEnd() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bDestroyAllSessionsOnScopeEnd);
    }

    @Nonnull
    public final EChange setDestroyAllSessionsOnScopeEnd(boolean bl) {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_bDestroyAllSessionsOnScopeEnd == bl) {
                return EChange.UNCHANGED;
            }
            this.m_bDestroyAllSessionsOnScopeEnd = bl;
            return EChange.CHANGED;
        });
    }

    public final boolean isEndAllSessionsOnScopeEnd() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bEndAllSessionsOnScopeEnd);
    }

    @Nonnull
    public final EChange setEndAllSessionsOnScopeEnd(boolean bl) {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_bEndAllSessionsOnScopeEnd == bl) {
                return EChange.UNCHANGED;
            }
            this.m_bEndAllSessionsOnScopeEnd = bl;
            return EChange.CHANGED;
        });
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    protected void onDestroy(@Nonnull IScope iScope) {
        if (this.isDestroyAllSessionsOnScopeEnd()) {
            this.destroyAllSessions();
        } else if (this.isEndAllSessionsOnScopeEnd()) {
            this._endAllSessionScopes();
        }
        INSTANCE = null;
    }

    private /* synthetic */ boolean lambda$onScopeEnd$2(String string, ISessionScope iSessionScope) {
        boolean bl = false;
        if (this.m_aSessionsInDestruction.add((Object)string)) {
            ISessionScope iSessionScope2 = (ISessionScope)this.m_aSessionScopes.remove((Object)string);
            if (!EqualsHelper.identityEqual((Object)iSessionScope2, (Object)iSessionScope)) {
                LOGGER.error("Ending an unknown session with ID '" + string + "'");
                LOGGER.error("  Scope to be removed: " + iSessionScope);
                LOGGER.error("  Removed scope:       " + iSessionScope2);
            }
            bl = true;
        } else {
            LOGGER.info("Already destructing session '" + string + "'");
        }
        return bl;
    }
}

