/*
 * Decompiled with CFR 0.152.
 */
package com.helger.matrix;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.matrix.Matrix;
import javax.annotation.Nonnull;

public class CholeskyDecomposition {
    private final double[][] m_aData;
    private final int m_nDim;
    private final boolean m_bIsSPD;

    public CholeskyDecomposition(@Nonnull Matrix matrix) {
        double[][] dArray = matrix.internalGetArray();
        this.m_nDim = matrix.getRowDimension();
        this.m_aData = new double[this.m_nDim][this.m_nDim];
        boolean bl = matrix.getColumnDimension() == this.m_nDim;
        for (int i = 0; i < this.m_nDim; ++i) {
            int n;
            double[] dArray2 = dArray[i];
            double[] dArray3 = this.m_aData[i];
            double d = 0.0;
            for (n = 0; n < i; ++n) {
                double[] dArray4 = this.m_aData[n];
                double d2 = 0.0;
                for (int j = 0; j < n; ++j) {
                    d2 += dArray4[j] * dArray3[j];
                }
                dArray3[n] = d2 = (dArray2[n] - d2) / dArray4[n];
                d += d2 * d2;
                bl = bl && EqualsHelper.equals((double)dArray[n][i], (double)dArray2[n]);
            }
            d = dArray2[i] - d;
            bl = bl && d > 0.0;
            dArray3[i] = Math.sqrt(Math.max(d, 0.0));
            for (n = i + 1; n < this.m_nDim; ++n) {
                dArray3[n] = 0.0;
            }
        }
        this.m_bIsSPD = bl;
    }

    public boolean isSPD() {
        return this.m_bIsSPD;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getL() {
        return new Matrix(this.m_aData, this.m_nDim, this.m_nDim);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix solve(@Nonnull Matrix matrix) {
        int n;
        int n2;
        double[] dArray;
        double[] dArray2;
        int n3;
        if (matrix.getRowDimension() != this.m_nDim) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.m_bIsSPD) {
            throw new IllegalStateException("Matrix is not symmetric positive definite.");
        }
        double[][] dArray3 = matrix.getArrayCopy();
        int n4 = matrix.getColumnDimension();
        for (n3 = 0; n3 < this.m_nDim; ++n3) {
            dArray2 = this.m_aData[n3];
            dArray = dArray3[n3];
            n2 = 0;
            while (n2 < n4) {
                for (n = 0; n < n3; ++n) {
                    int n5 = n2;
                    dArray[n5] = dArray[n5] - dArray3[n][n2] * dArray2[n];
                }
                int n6 = n2++;
                dArray[n6] = dArray[n6] / dArray2[n3];
            }
        }
        for (n3 = this.m_nDim - 1; n3 >= 0; --n3) {
            dArray2 = this.m_aData[n3];
            dArray = dArray3[n3];
            n2 = 0;
            while (n2 < n4) {
                for (n = n3 + 1; n < this.m_nDim; ++n) {
                    int n7 = n2;
                    dArray[n7] = dArray[n7] - dArray3[n][n2] * this.m_aData[n][n3];
                }
                int n8 = n2++;
                dArray[n8] = dArray[n8] / dArray2[n3];
            }
        }
        return new Matrix(dArray3, this.m_nDim, n4);
    }
}

