/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser.handler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.json.parser.handler.IJsonParserHandler;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class StringAssemblyJsonParserHandler
implements IJsonParserHandler {
    private final StringBuilder m_aSB = new StringBuilder();

    @Override
    public void onWhitespace(@NonNull @Nonempty String string) {
        this.m_aSB.append(string);
    }

    @Override
    public void onComment(@NonNull String string) {
        this.m_aSB.append("/*").append(string).append("*/");
    }

    @Override
    public void onString(@NonNull String string, @NonNull String string2) {
        this.m_aSB.append(string);
    }

    @Override
    public void onNumber(@NonNull String string, @NonNull Number number) {
        this.m_aSB.append(string);
    }

    @Override
    public void onFalse() {
        this.m_aSB.append("false");
    }

    @Override
    public void onTrue() {
        this.m_aSB.append("true");
    }

    @Override
    public void onNull() {
        this.m_aSB.append("null");
    }

    @Override
    public void onArrayStart() {
        this.m_aSB.append('[');
    }

    @Override
    public void onArrayNextElement() {
        this.m_aSB.append(',');
    }

    @Override
    public void onArrayEnd() {
        this.m_aSB.append(']');
    }

    @Override
    public void onObjectStart() {
        this.m_aSB.append('{');
    }

    @Override
    public void onObjectName(@NonNull String string, @NonNull String string2) {
        this.m_aSB.append(string);
    }

    @Override
    public void onObjectColon() {
        this.m_aSB.append(':');
    }

    @Override
    public void onObjectNextElement() {
        this.m_aSB.append(',');
    }

    @Override
    public void onObjectEnd() {
        this.m_aSB.append('}');
    }

    public @NonNull String getJsonString() {
        return this.m_aSB.toString();
    }
}

