/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.clone.ICloneable;
import com.helger.base.trait.IAddableByTrait;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonWriter;
import com.helger.json.serialize.JsonWriterSettings;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
public interface IJson
extends ICloneable<IJson>,
IAddableByTrait {
    public boolean isArray();

    default public @Nullable IJsonArray getAsArray() {
        return this.isArray() ? (IJsonArray)this : null;
    }

    public boolean isObject();

    default public @Nullable IJsonObject getAsObject() {
        return this.isObject() ? (IJsonObject)this : null;
    }

    public boolean isValue();

    default public @Nullable IJsonValue getAsValue() {
        return this.isValue() ? (IJsonValue)this : null;
    }

    default public @NonNull String getAsJsonString() {
        return this.getAsJsonString(JsonWriterSettings.DEFAULT_SETTINGS);
    }

    default public @NonNull String getAsJsonString(@NonNull IJsonWriterSettings iJsonWriterSettings) {
        return new JsonWriter(iJsonWriterSettings).writeAsString(this);
    }
}

