/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.mapping;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.rt.StackTraceHelper;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.json.mapping.JsonUnmappedException;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class JsonMapper {
    public static final String JSON_TRISTATE_TRUE = "TRUE";
    public static final String JSON_TRISTATE_FALSE = "FALSE";
    public static final String JSON_TRISTATE_UNDEFINED = "UNDEFINED";
    public static final String JSON_CLASS = "class";
    public static final String JSON_MESSAGE = "message";
    public static final String JSON_STACK_TRACE = "stackTrace";
    public static final String JSON_RESOURCE_ID = "resource";
    public static final String JSON_LINE_NUM = "line";
    public static final String JSON_COLUMN_NUM = "col";

    private JsonMapper() {
    }

    public static @NonNull @Nonempty String getJsonTriState(boolean bl) {
        return bl ? JSON_TRISTATE_TRUE : JSON_TRISTATE_FALSE;
    }

    public static @Nullable String getJsonTriState(@Nullable ETriState eTriState) {
        if (eTriState == null) {
            return null;
        }
        if (eTriState.isUndefined()) {
            return JSON_TRISTATE_UNDEFINED;
        }
        return JsonMapper.getJsonTriState(eTriState.isTrue());
    }

    public static @Nullable ETriState getAsTriState(@Nullable String string) {
        if (JSON_TRISTATE_TRUE.equals(string)) {
            return ETriState.TRUE;
        }
        if (JSON_TRISTATE_FALSE.equals(string)) {
            return ETriState.FALSE;
        }
        if (JSON_TRISTATE_UNDEFINED.equals(string)) {
            return ETriState.UNDEFINED;
        }
        return null;
    }

    public static @Nullable IJsonObject getJsonException(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof JsonUnmappedException) {
            JsonUnmappedException jsonUnmappedException = (JsonUnmappedException)throwable;
            return jsonUnmappedException.getAsJson();
        }
        return (IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add(JSON_CLASS, throwable.getClass().getName())).addIfNotNull(JSON_MESSAGE, throwable.getMessage())).add(JSON_STACK_TRACE, StackTraceHelper.getStackAsString((Throwable)throwable));
    }

    public static @Nullable JsonUnmappedException getAsUnmappedException(@Nullable IJsonObject iJsonObject) {
        if (iJsonObject == null) {
            return null;
        }
        String string = iJsonObject.getAsString(JSON_CLASS);
        String string2 = iJsonObject.getAsString(JSON_MESSAGE);
        List list = StringHelper.getExploded((String)"\n", (String)iJsonObject.getAsString(JSON_STACK_TRACE));
        if (string == null) {
            return null;
        }
        return new JsonUnmappedException(string, string2, list);
    }

    public static @Nullable IJsonObject getJsonSimpleLocation(@Nullable ILocation iLocation) {
        if (iLocation == null || !iLocation.isAnyInformationPresent()) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        if (iLocation.hasResourceID()) {
            jsonObject.add(JSON_RESOURCE_ID, iLocation.getResourceID());
        }
        if (iLocation.hasLineNumber()) {
            jsonObject.add(JSON_LINE_NUM, iLocation.getLineNumber());
        }
        if (iLocation.hasColumnNumber()) {
            jsonObject.add(JSON_COLUMN_NUM, iLocation.getColumnNumber());
        }
        return jsonObject;
    }

    public static @Nullable ILocation getAsSimpleLocation(@Nullable IJsonObject iJsonObject) {
        if (iJsonObject == null) {
            return null;
        }
        String string = iJsonObject.getAsString(JSON_RESOURCE_ID);
        int n = iJsonObject.getAsInt(JSON_LINE_NUM, -1);
        int n2 = iJsonObject.getAsInt(JSON_COLUMN_NUM, -1);
        if (StringHelper.isEmpty((String)string) && n < 0 && n2 < 0) {
            return null;
        }
        return new SimpleLocation(string, n, n2);
    }
}

