/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.valueserializer;

import com.helger.annotation.WillNotClose;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.json.convert.JsonEscapeHelper;
import com.helger.json.valueserializer.IJsonValueSerializer;
import java.io.IOException;
import java.io.Writer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class JsonValueSerializerEscaped
implements IJsonValueSerializer {
    private static final JsonValueSerializerEscaped INSTANCE = new JsonValueSerializerEscaped();

    private JsonValueSerializerEscaped() {
    }

    public static @NonNull JsonValueSerializerEscaped getInstance() {
        return INSTANCE;
    }

    public static void appendEscapedJsonString(@NonNull String string, @WillNotClose @NonNull Writer writer) throws IOException {
        writer.write(34);
        JsonEscapeHelper.jsonEscapeToWriter(string, writer);
        writer.write(34);
    }

    @Override
    public void appendAsJsonString(@Nullable Object object, @WillNotClose @NonNull Writer writer) throws IOException {
        JsonValueSerializerEscaped.appendEscapedJsonString(String.valueOf(object), writer);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

