/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.json.parser.IJsonParserSettings;
import jakarta.annotation.Nonnull;

@NotThreadSafe
public final class JsonParserSettings
implements IJsonParserSettings {
    public static final boolean DEFAULT_TRACK_POSITION = false;
    public static final int DEFAULT_TAB_SIZE = 8;
    public static final boolean DEFAULT_ALWAYS_USE_BIG_NUMBER = false;
    public static final boolean DEFAULT_REQUIRE_STRING_QUOTES = true;
    public static final boolean DEFAULT_ALLOW_SPECIAL_CHARS_IN_STRING = false;
    public static final boolean DEFAULT_CHECK_FOR_EOI = true;
    public static final int DEFAULT_MAX_NESTING_DEPTH = 1000;
    private boolean m_bTrackPosition = false;
    private int m_nTabSize = 8;
    private boolean m_bAlwaysUseBigNumber = false;
    private boolean m_bRequireStringQuotes = true;
    private boolean m_bAllowSpecialCharsInStrings = false;
    private boolean m_bCheckForEOI = true;
    private int m_nMaxNestingDepth = 1000;

    public JsonParserSettings() {
    }

    public JsonParserSettings(@Nonnull IJsonParserSettings iJsonParserSettings) {
        this.assignFrom(iJsonParserSettings);
    }

    @Override
    public boolean isTrackPosition() {
        return this.m_bTrackPosition;
    }

    @Nonnull
    public JsonParserSettings setTrackPosition(boolean bl) {
        this.m_bTrackPosition = bl;
        return this;
    }

    @Override
    @Nonnegative
    public int getTabSize() {
        return this.m_nTabSize;
    }

    @Nonnull
    public JsonParserSettings setTabSize(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"TabSize");
        this.m_nTabSize = n;
        return this;
    }

    @Override
    public boolean isAlwaysUseBigNumber() {
        return this.m_bAlwaysUseBigNumber;
    }

    @Nonnull
    public JsonParserSettings setAlwaysUseBigNumber(boolean bl) {
        this.m_bAlwaysUseBigNumber = bl;
        return this;
    }

    @Override
    public boolean isRequireStringQuotes() {
        return this.m_bRequireStringQuotes;
    }

    @Nonnull
    public JsonParserSettings setRequireStringQuotes(boolean bl) {
        this.m_bRequireStringQuotes = bl;
        return this;
    }

    @Override
    public boolean isAllowSpecialCharsInStrings() {
        return this.m_bAllowSpecialCharsInStrings;
    }

    @Nonnull
    public JsonParserSettings setAllowSpecialCharsInStrings(boolean bl) {
        this.m_bAllowSpecialCharsInStrings = bl;
        return this;
    }

    @Override
    public boolean isCheckForEOI() {
        return this.m_bCheckForEOI;
    }

    @Nonnull
    public JsonParserSettings setCheckForEOI(boolean bl) {
        this.m_bCheckForEOI = bl;
        return this;
    }

    @Override
    @Nonnegative
    public int getMaxNestingDepth() {
        return this.m_nMaxNestingDepth;
    }

    @Nonnull
    public JsonParserSettings setMaxNestingDepth(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"MaxNestingDepth");
        this.m_nMaxNestingDepth = n;
        return this;
    }

    public void assignFrom(@Nonnull IJsonParserSettings iJsonParserSettings) {
        ValueEnforcer.notNull((Object)iJsonParserSettings, (String)"rhs");
        this.setTrackPosition(iJsonParserSettings.isTrackPosition());
        this.setTabSize(iJsonParserSettings.getTabSize());
        this.setAlwaysUseBigNumber(iJsonParserSettings.isAlwaysUseBigNumber());
        this.setRequireStringQuotes(iJsonParserSettings.isRequireStringQuotes());
        this.setAllowSpecialCharsInStrings(iJsonParserSettings.isAllowSpecialCharsInStrings());
        this.setCheckForEOI(iJsonParserSettings.isCheckForEOI());
        this.setMaxNestingDepth(iJsonParserSettings.getMaxNestingDepth());
    }

    public String toString() {
        return new ToStringGenerator(null).append("TrackPosition", this.m_bTrackPosition).append("TabSize", this.m_nTabSize).append("AlwaysUseBugBumber", this.m_bAlwaysUseBigNumber).append("RequireStringQuotes", this.m_bRequireStringQuotes).append("AllowSpecialCharsInStrings", this.m_bAllowSpecialCharsInStrings).append("CheckForEOI", this.m_bCheckForEOI).append("MaxNestingDepth", this.m_nMaxNestingDepth).getToString();
    }
}

