/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.trait.IGenericMapAdderTrait;
import com.helger.base.trait.ITypeConverterTo;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonCollection;
import com.helger.json.IJsonValue;
import com.helger.json.JsonValue;
import com.helger.json.TypeConverterToIJson;
import com.helger.typeconvert.trait.IGetterByKeyTrait;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface IJsonObject
extends IJsonCollection,
ICommonsIterable<Map.Entry<String, IJson>>,
IGetterByKeyTrait<String>,
IGenericMapAdderTrait<String, IJson, IJsonObject> {
    @Nonnull
    default public ITypeConverterTo<IJson> getTypeConverterTo() {
        return TypeConverterToIJson.INSTANCE;
    }

    @Nonnegative
    public int size();

    @Nullable
    public IJson removeKeyAndReturnValue(@Nullable String var1);

    @Nonnull
    public EChange removeKey(@Nullable String var1);

    public boolean containsKey(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> keySet();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> values();

    @Nullable
    public IJson get(@Nullable String var1);

    @Nullable
    default public Object getValue(@Nullable String string) {
        IJsonValue iJsonValue;
        IJson iJson = this.get(string);
        if (iJson != null && (iJsonValue = iJson.getAsValue()) != null) {
            return iJsonValue.getValue();
        }
        return null;
    }

    @Nullable
    default public IJsonValue getAsValue(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsValue() : null;
    }

    @Nullable
    default public IJsonArray getAsArray(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsArray() : null;
    }

    @Nullable
    default public IJsonObject getAsObject(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsObject() : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, IJson> getAll();

    public void forEach(@Nonnull BiConsumer<? super String, ? super IJson> var1);

    public boolean containsValue(@Nullable IJson var1);

    default public boolean containsValue(@Nullable Object object) {
        return this.containsValue(JsonValue.create(object));
    }

    default public boolean containsValue(boolean bl) {
        return this.containsValue(JsonValue.create(bl));
    }

    default public boolean containsValue(char c) {
        return this.containsValue(JsonValue.create(c));
    }

    default public boolean containsValue(double d) {
        return this.containsValue(JsonValue.create(d));
    }

    default public boolean containsValue(int n) {
        return this.containsValue(JsonValue.create(n));
    }

    default public boolean containsValue(long l) {
        return this.containsValue(JsonValue.create(l));
    }

    @Nullable
    default public IJson computeIfAbsent(@Nonnull String string, @Nonnull Function<? super String, ? extends IJson> function) {
        IJson iJson = this.get(string);
        if (iJson == null && (iJson = function.apply(string)) != null) {
            this.add(string, iJson);
        }
        return iJson;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, IJson> getClonedValues();

    @Nonnull
    public IJsonObject getClone();
}

