/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.commons.traits.IPrimitiveConverterTo;
import com.helger.json.IJson;
import com.helger.json.JsonValue;
import com.helger.json.convert.JsonConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrimitiveConvererToIJson
implements IPrimitiveConverterTo<IJson> {
    public static final PrimitiveConvererToIJson INSTANCE = new PrimitiveConvererToIJson();

    protected PrimitiveConvererToIJson() {
    }

    @Nonnull
    public IJson convert(boolean bl) {
        return JsonValue.create(bl);
    }

    @Nonnull
    public IJson convert(byte by) {
        return this.convert((int)by);
    }

    @Nonnull
    public IJson convert(char c) {
        return JsonValue.create(c);
    }

    @Nonnull
    public IJson convert(double d) {
        return JsonValue.create(d);
    }

    @Nonnull
    public IJson convert(float f) {
        return this.convert((double)f);
    }

    @Nonnull
    public IJson convert(int n) {
        return JsonValue.create(n);
    }

    @Nonnull
    public IJson convert(long l) {
        return JsonValue.create(l);
    }

    @Nonnull
    public IJson convert(short s) {
        return this.convert((int)s);
    }

    @Nonnull
    public IJson convert(@Nullable Object object) {
        return JsonConverter.convertToJson(object);
    }
}

