/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.NonClosingReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.EValidity;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.parser.IJsonParserCustomizeCallback;
import com.helger.json.parser.JsonParseException;
import com.helger.json.parser.JsonParser;
import com.helger.json.parser.errorhandler.IJsonParseExceptionCallback;
import com.helger.json.parser.errorhandler.LoggingJsonParseExceptionCallback;
import com.helger.json.parser.handler.CollectingJsonParserHandler;
import com.helger.json.parser.handler.DoNothingJsonParserHandler;
import com.helger.json.parser.handler.IJsonParserHandler;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JsonReader {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonReader.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IJsonParseExceptionCallback s_aDefaultParseExceptionCallback = new LoggingJsonParseExceptionCallback();
    private static final JsonReader INSTANCE = new JsonReader();

    private JsonReader() {
    }

    @Nonnull
    public static IJsonParseExceptionCallback getDefaultParseExceptionCallback() {
        return (IJsonParseExceptionCallback)RW_LOCK.readLockedGet(() -> s_aDefaultParseExceptionCallback);
    }

    public static void setDefaultParseExceptionCallback(@Nonnull IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iJsonParseExceptionCallback, (String)"DefaultParseExceptionCallback");
        RW_LOCK.writeLocked(() -> {
            s_aDefaultParseExceptionCallback = iJsonParseExceptionCallback;
        });
    }

    @Nonnull
    public static ESuccess parseJson(@Nonnull @WillClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler) {
        return JsonReader.parseJson(reader, iJsonParserHandler, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess parseJson(@Nonnull @WillClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler, @Nullable IJsonParserCustomizeCallback iJsonParserCustomizeCallback, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)iJsonParserHandler, (String)"ParserHandler");
        try {
            JsonParser jsonParser = new JsonParser(reader, iJsonParserHandler);
            if (iJsonParserCustomizeCallback != null) {
                iJsonParserCustomizeCallback.customizeJsonParser(jsonParser);
            }
            jsonParser.parse();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (JsonParseException jsonParseException) {
            if (iJsonParseExceptionCallback != null) {
                iJsonParseExceptionCallback.onException(jsonParseException);
            } else {
                JsonReader.getDefaultParseExceptionCallback().onException(jsonParseException);
            }
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    @Nonnull
    private static EValidity _validateJson(@Nonnull @WillClose Reader reader) {
        ESuccess eSuccess = JsonReader.parseJson(reader, new DoNothingJsonParserHandler(), null, jsonParseException -> {});
        return EValidity.valueOf((boolean)eSuccess.isSuccess());
    }

    @Nullable
    public static IJson readJson(@Nonnull @WillClose Reader reader, @Nullable IJsonParserCustomizeCallback iJsonParserCustomizeCallback, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        CollectingJsonParserHandler collectingJsonParserHandler = new CollectingJsonParserHandler();
        if (JsonReader.parseJson(reader, collectingJsonParserHandler, iJsonParserCustomizeCallback, iJsonParseExceptionCallback).isFailure()) {
            return null;
        }
        return collectingJsonParserHandler.getJson();
    }

    @Nullable
    public static IJson readFromString(@Nonnull String string) {
        return JsonReader.builder().source(string).read();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builderMultiObject() {
        return JsonReader.builder().dontCloseSource(true).useBufferedReader(false).customizeCallback(jsonParser -> jsonParser.setCheckForEOI(false));
    }

    public static class Builder
    implements AutoCloseable {
        private boolean m_bDontCloseSource = false;
        private boolean m_bUseBufferedReader = true;
        private Reader m_aReader;
        private IJsonParserCustomizeCallback m_aCustomizeCallback;
        private IJsonParseExceptionCallback m_aCustomExceptionCallback;

        @Override
        public void close() {
            StreamHelper.close((AutoCloseable)this.m_aReader);
        }

        @Nonnull
        public Builder dontCloseSource(boolean bl) {
            this.m_bDontCloseSource = bl;
            return this;
        }

        @Nonnull
        public Builder useBufferedReader(boolean bl) {
            this.m_bUseBufferedReader = bl;
            return this;
        }

        @Nonnull
        public Builder source(@Nonnull String string) {
            ValueEnforcer.notNull((Object)string, (String)"Json");
            return this.source((Reader)new NonBlockingStringReader(string));
        }

        @Nonnull
        public Builder source(@Nonnull File file) {
            return this.source(file, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder source(@Nonnull File file, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)file, (String)"File");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            return this.source((IHasInputStream)new FileSystemResource(file), charset);
        }

        @Nonnull
        public Builder source(@Nonnull Path path) {
            return this.source(path, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder source(@Nonnull Path path, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)path, (String)"Path");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            return this.source((IHasInputStream)new FileSystemResource(path), charset);
        }

        @Nonnull
        public Builder source(@Nonnull byte[] byArray) {
            return this.source(byArray, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder source(@Nonnull byte[] byArray, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            return this.source((InputStream)new NonBlockingByteArrayInputStream(byArray), charset);
        }

        @Nonnull
        public Builder source(@Nonnull IHasInputStream iHasInputStream) {
            return this.source(iHasInputStream, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder source(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            InputStream inputStream = iHasInputStream.getInputStream();
            if (inputStream != null) {
                this.source(inputStream, charset);
            }
            return this;
        }

        @Nonnull
        public Builder source(@Nonnull @WillClose InputStream inputStream) {
            return this.source(inputStream, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder source(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            return this.source(CharsetHelper.getReaderByBOM((InputStream)inputStream, (Charset)charset));
        }

        @Nonnull
        public Builder source(@Nonnull @WillClose Reader reader) {
            ValueEnforcer.notNull((Object)reader, (String)"Reader");
            if (this.m_aReader != null) {
                LOGGER.warn("Another source is already present - this may cause a resource leak, because the old source is not closed automatically");
            }
            this.m_aReader = reader;
            return this;
        }

        @Nonnull
        public Builder customizeCallback(@Nullable IJsonParserCustomizeCallback iJsonParserCustomizeCallback) {
            this.m_aCustomizeCallback = iJsonParserCustomizeCallback;
            return this;
        }

        @Nonnull
        public Builder customExceptionCallback(@Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
            this.m_aCustomExceptionCallback = iJsonParseExceptionCallback;
            return this;
        }

        public boolean hasSource() {
            return this.m_aReader != null;
        }

        @Nonnull
        private Reader _getEffectiveReader() {
            Reader reader = this.m_aReader;
            if (this.m_bUseBufferedReader) {
                reader = StreamHelper.getBuffered((Reader)reader);
            }
            if (this.m_bDontCloseSource) {
                reader = new NonClosingReader(reader);
            }
            return reader;
        }

        public boolean isValidJson() {
            if (this.m_aReader == null) {
                throw new IllegalStateException("No source is set.");
            }
            return JsonReader.parseJson(this._getEffectiveReader(), new DoNothingJsonParserHandler(), this.m_aCustomizeCallback, this.m_aCustomExceptionCallback).isSuccess();
        }

        @Nullable
        public IJson read() {
            if (this.m_aReader == null) {
                throw new IllegalStateException("No source is set.");
            }
            return JsonReader.readJson(this._getEffectiveReader(), this.m_aCustomizeCallback, this.m_aCustomExceptionCallback);
        }

        @Nullable
        public IJsonArray readAsArray() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsArray();
        }

        @Nullable
        public IJsonObject readAsObject() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsObject();
        }

        @Nullable
        public IJsonValue readAsValue() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsValue();
        }
    }
}

