/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.SingleErrorBuilder;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.jaxb.validation.IValidationEventHandler;
import com.helger.xml.serialize.write.XMLWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventLocator;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@NotThreadSafe
public abstract class AbstractValidationEventHandler
implements IValidationEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractValidationEventHandler.class);

    protected AbstractValidationEventHandler() {
    }

    @Nonnull
    @OverrideOnDemand
    protected IErrorLevel getErrorLevel(int n) {
        switch (n) {
            case 0: {
                return EErrorLevel.WARN;
            }
            case 1: {
                return EErrorLevel.ERROR;
            }
            case 2: {
                return EErrorLevel.FATAL_ERROR;
            }
        }
        LOGGER.warn("Unknown JAXB validation severity: " + n + "; defaulting to error");
        return EErrorLevel.ERROR;
    }

    @Nullable
    @OverrideOnDemand
    protected String getLocationResourceID(@Nullable ValidationEventLocator validationEventLocator) {
        URL uRL;
        if (validationEventLocator != null && (uRL = validationEventLocator.getURL()) != null) {
            return uRL.toString();
        }
        return null;
    }

    @Nullable
    @OverrideOnDemand
    protected String getErrorFieldName(@Nullable ValidationEventLocator validationEventLocator) {
        if (validationEventLocator != null) {
            Object object = validationEventLocator.getObject();
            if (object != null) {
                return "obj: " + object.toString();
            }
            Node node = validationEventLocator.getNode();
            if (node != null) {
                return XMLWriter.getNodeAsString((Node)node);
            }
        }
        return null;
    }

    @OverrideOnDemand
    protected abstract void onEvent(@Nonnull IError var1);

    @OverrideOnDemand
    protected boolean continueProcessing(@Nonnull IErrorLevel iErrorLevel) {
        return iErrorLevel.isLT((IErrorLevel)EErrorLevel.FATAL_ERROR);
    }

    public final boolean handleEvent(@Nonnull ValidationEvent validationEvent) {
        IErrorLevel iErrorLevel = this.getErrorLevel(validationEvent.getSeverity());
        SingleErrorBuilder singleErrorBuilder = (SingleErrorBuilder)SingleError.builder().errorLevel(iErrorLevel);
        ValidationEventLocator validationEventLocator = validationEvent.getLocator();
        ((SingleErrorBuilder)singleErrorBuilder.errorLocation((ILocation)new SimpleLocation(this.getLocationResourceID(validationEventLocator), validationEventLocator != null ? validationEventLocator.getLineNumber() : -1, validationEventLocator != null ? validationEventLocator.getColumnNumber() : -1))).errorFieldName(this.getErrorFieldName(validationEventLocator));
        String string = validationEvent.getMessage();
        if (string == null) {
            if (validationEvent.getLinkedException() != null) {
                string = validationEvent.getLinkedException().getMessage();
                if (string == null) {
                    string = "Exception";
                }
            } else {
                string = "Validation event";
            }
        }
        ((SingleErrorBuilder)singleErrorBuilder.errorText(string)).linkedException(validationEvent.getLinkedException());
        this.onEvent((IError)singleErrorBuilder.build());
        return this.continueProcessing(iErrorLevel);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

