/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.web.PDTWebDateHelper;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterOffsetTime
extends XmlAdapter<String, OffsetTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterOffsetTime.class);
    private static Function<LocalTime, ZoneOffset> s_aZOSupplier = localTime -> ZoneOffset.UTC;

    public static @NonNull Function<LocalTime, ZoneOffset> getFallbackZoneOffsetSupplier() {
        return s_aZOSupplier;
    }

    public static void setFallbackZoneOffsetSupplier(@NonNull Function<LocalTime, ZoneOffset> function) {
        ValueEnforcer.notNull(function, (String)"ZoneOffsetSupplier");
        s_aZOSupplier = function;
    }

    public OffsetTime unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        OffsetTime offsetTime = PDTWebDateHelper.getOffsetTimeFromXSD((String)string2);
        if (offsetTime == null) {
            LocalTime localTime = PDTWebDateHelper.getLocalTimeFromXSD((String)string2);
            if (localTime != null) {
                offsetTime = OffsetTime.of(localTime, AdapterOffsetTime.getFallbackZoneOffsetSupplier().apply(localTime));
            } else {
                LOGGER.warn("Failed to parse '" + string + "' to an OffsetTime");
            }
        }
        return offsetTime;
    }

    public String marshal(@Nullable OffsetTime offsetTime) {
        return PDTWebDateHelper.getAsStringXSD((OffsetTime)offsetTime);
    }
}

