/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.url.URLHelper;
import com.helger.base.wrapper.IMutableWrapper;
import com.helger.io.resource.IReadableResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class URLResource
implements IReadableResource {
    public static final int DEFAULT_CONNECT_TIMEOUT = -1;
    public static final int DEFAULT_READ_TIMEOUT = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(URLResource.class);
    private final URL m_aURL;

    public URLResource(@NonNull String string) throws MalformedURLException {
        this(new URL(string));
    }

    public URLResource(@NonNull URI uRI) throws MalformedURLException {
        this(uRI.toURL());
    }

    public URLResource(@NonNull URL uRL) {
        this.m_aURL = (URL)ValueEnforcer.notNull((Object)uRL, (String)"URL");
    }

    public static boolean isExplicitURLResource(@Nullable String string) {
        return URLHelper.getAsURL((String)string, (boolean)false) != null;
    }

    @Override
    public @NonNull String getResourceID() {
        return this.getPath();
    }

    @Override
    public @NonNull String getPath() {
        return this.m_aURL.toExternalForm();
    }

    public static @Nullable InputStream getInputStream(@NonNull URL uRL) {
        return URLHelper.getInputStream((URL)uRL, (int)-1, (int)-1, null, (IMutableWrapper)null);
    }

    public @Nullable InputStream getInputStream() {
        return this.getInputStream(-1, -1);
    }

    public @Nullable InputStream getInputStream(@CheckForSigned int n, @CheckForSigned int n2) {
        return this.getInputStream(n, n2, null, (IMutableWrapper<IOException>)((IMutableWrapper)null));
    }

    public @Nullable InputStream getInputStream(@Nullable IMutableWrapper<IOException> iMutableWrapper) {
        return this.getInputStream(-1, -1, iMutableWrapper);
    }

    public @Nullable InputStream getInputStream(@CheckForSigned int n, @CheckForSigned int n2, @Nullable IMutableWrapper<IOException> iMutableWrapper) {
        return this.getInputStream(n, n2, null, iMutableWrapper);
    }

    public @Nullable InputStream getInputStream(@CheckForSigned int n, @CheckForSigned int n2, @Nullable Consumer<? super URLConnection> consumer, @Nullable IMutableWrapper<IOException> iMutableWrapper) {
        return URLHelper.getInputStream((URL)this.m_aURL, (int)n, (int)n2, consumer, iMutableWrapper);
    }

    public final boolean isReadMultiple() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        if ("file".equals(this.m_aURL.getProtocol())) {
            return this.getAsFile().exists();
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            boolean bl = inputStream != null;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Override
    public @NonNull URL getAsURL() {
        return this.m_aURL;
    }

    public @Nullable URI getAsURI() {
        return URLHelper.getAsURI((URL)this.m_aURL);
    }

    @Override
    public @Nullable File getAsFile() {
        return URLHelper.getAsFileOrNull((URL)this.m_aURL);
    }

    public @NonNull URLResource getReadableCloneForPath(@NonNull URL uRL) {
        return new URLResource(uRL);
    }

    @Override
    public @NonNull URLResource getReadableCloneForPath(@NonNull String string) {
        try {
            return new URLResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Cannot convert to an URL: " + string, malformedURLException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLResource uRLResource = (URLResource)object;
        return EqualsHelper.equals((Object)this.m_aURL, (Object)uRLResource.m_aURL);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("url", (Object)this.m_aURL).getToString();
    }
}

