/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.EAppend;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.base.io.stream.ByteBufferOutputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.io.file.ERandomAccessFileMode;
import com.helger.io.file.FileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FileChannelHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileChannelHelper.class);
    private static final FileChannelHelper INSTANCE = new FileChannelHelper();

    private FileChannelHelper() {
    }

    @CheckForSigned
    public static long getFileSize(@Nullable FileChannel fileChannel) {
        if (fileChannel != null) {
            try {
                return fileChannel.size();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private static @Nullable InputStream _getMappedInputStream(@WillNotClose @NonNull FileChannel fileChannel, @NonNull File file) {
        try {
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            LOGGER.info("Created memory mapped input stream for " + String.valueOf(file));
            return new ByteBufferInputStream((ByteBuffer)mappedByteBuffer);
        }
        catch (IOException iOException) {
            LOGGER.warn("Failed to create memory mapped input stream for " + String.valueOf(file), (Throwable)iOException);
            return null;
        }
    }

    public static @Nullable InputStream getInputStream(@NonNull File file) {
        InputStream inputStream;
        FileChannel fileChannel;
        ValueEnforcer.notNull((Object)file, (String)"File");
        FileInputStream fileInputStream = FileHelper.getInputStream(file);
        if (fileInputStream != null && FileChannelHelper.getFileSize(fileChannel = fileInputStream.getChannel()) > 0x100000L && (inputStream = FileChannelHelper._getMappedInputStream(fileChannel, file)) != null) {
            return inputStream;
        }
        return fileInputStream;
    }

    public static @Nullable FileChannel getFileReadChannel(@NonNull String string) {
        return FileChannelHelper.getFileReadChannel(new File(string));
    }

    public static @Nullable FileChannel getFileReadChannel(@NonNull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        FileInputStream fileInputStream = FileHelper.getInputStream(file);
        return fileInputStream == null ? null : fileInputStream.getChannel();
    }

    public static @Nullable InputStream getMappedInputStream(@NonNull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        FileInputStream fileInputStream = FileHelper.getInputStream(file);
        if (fileInputStream == null) {
            return null;
        }
        InputStream inputStream = FileChannelHelper._getMappedInputStream(fileInputStream.getChannel(), file);
        if (inputStream != null) {
            return inputStream;
        }
        LOGGER.warn("Failed to map file " + String.valueOf(file) + ". Falling though to regular FileInputStream");
        return fileInputStream;
    }

    private static @Nullable OutputStream _getMappedOutputStream(@WillNotClose @NonNull FileChannel fileChannel, @NonNull File file) {
        try {
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
            LOGGER.info("Created memory mapped output stream for " + String.valueOf(file));
            return new ByteBufferOutputStream((ByteBuffer)mappedByteBuffer, false);
        }
        catch (IOException iOException) {
            LOGGER.warn("Failed to create memory mapped output stream for " + String.valueOf(file), (Throwable)iOException);
            return null;
        }
    }

    public static @Nullable FileChannel getFileWriteChannel(@NonNull String string) {
        return FileChannelHelper.getFileWriteChannel(string, EAppend.DEFAULT);
    }

    public static @Nullable FileChannel getFileWriteChannel(@NonNull String string, @NonNull EAppend eAppend) {
        return FileChannelHelper.getFileWriteChannel(new File(string), eAppend);
    }

    public static @Nullable FileChannel getFileWriteChannel(@NonNull File file) {
        return FileChannelHelper.getFileWriteChannel(file, EAppend.DEFAULT);
    }

    public static @Nullable FileChannel getFileWriteChannel(@NonNull File file, @NonNull EAppend eAppend) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        ValueEnforcer.notNull((Object)eAppend, (String)"Append");
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file, eAppend);
        return fileOutputStream == null ? null : fileOutputStream.getChannel();
    }

    public static @Nullable OutputStream getMappedOutputStream(@NonNull String string) {
        return FileChannelHelper.getMappedOutputStream(new File(string));
    }

    public static @Nullable OutputStream getMappedOutputStream(@NonNull String string, @NonNull EAppend eAppend) {
        return FileChannelHelper.getMappedOutputStream(new File(string), eAppend);
    }

    public static @Nullable OutputStream getMappedOutputStream(@NonNull File file) {
        return FileChannelHelper.getMappedOutputStream(file, EAppend.DEFAULT);
    }

    public static @Nullable OutputStream getMappedOutputStream(@NonNull File file, @NonNull EAppend eAppend) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        ValueEnforcer.notNull((Object)eAppend, (String)"Append");
        if (FileHelper.internalCheckParentDirectoryExistanceAndAccess(file).isInvalid()) {
            return null;
        }
        RandomAccessFile randomAccessFile = FileHelper.getRandomAccessFile(file, ERandomAccessFileMode.READ_WRITE);
        if (randomAccessFile == null) {
            LOGGER.error("Failed to open random access file " + String.valueOf(file));
            return null;
        }
        OutputStream outputStream = FileChannelHelper._getMappedOutputStream(randomAccessFile.getChannel(), file);
        if (outputStream != null) {
            return outputStream;
        }
        StreamHelper.close((AutoCloseable)randomAccessFile);
        LOGGER.warn("Failed to map file " + String.valueOf(file) + ". Falling though to regular FileOutputStream");
        return FileHelper.getOutputStream(file, eAppend);
    }
}

