/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.rt;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.rt.NonBlockingProperties;
import com.helger.base.rt.PropertiesHelper;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

@Immutable
public final class PropertiesLoader {
    private PropertiesLoader() {
    }

    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return PropertiesLoader.loadProperties(new FileSystemResource(file));
    }

    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull File file, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return PropertiesLoader.loadProperties(new FileSystemResource(file), charset);
    }

    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        InputStream inputStream = iReadableResource.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return PropertiesHelper.loadProperties((InputStream)inputStream);
    }

    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            return null;
        }
        return PropertiesHelper.loadProperties((Reader)reader);
    }
}

