/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.AbstractQValueList;
import com.helger.http.header.QValue;
import com.helger.http.header.specific.AcceptMimeTypeHandler;
import com.helger.mime.IMimeType;
import com.helger.mime.parse.MimeTypeParser;
import com.helger.mime.parse.MimeTypeParserException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class AcceptMimeTypeList
extends AbstractQValueList<IMimeType> {
    public @NonNull AcceptMimeTypeList addMimeType(@NonNull @Nonempty String string, @Nonnegative double d) throws MimeTypeParserException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MimeType");
        return this.addMimeType((IMimeType)MimeTypeParser.parseMimeType((String)string), d);
    }

    public @NonNull AcceptMimeTypeList addMimeType(@NonNull IMimeType iMimeType, @Nonnegative double d) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        ValueEnforcer.isFalse((boolean)iMimeType.hasAnyParameters(), (String)"MimeTypes used here may not contain any parameter!");
        this.qvalueMap().put((Object)iMimeType, (Object)new QValue(d));
        return this;
    }

    public @NonNull QValue getQValueOfMimeType(@NonNull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        IMimeType iMimeType2 = iMimeType.getCopyWithoutParameters();
        QValue qValue = (QValue)this.qvalueMap().get((Object)iMimeType2);
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)iMimeType2.getContentType().buildMimeType("*"))) == null && (qValue = (QValue)this.qvalueMap().get((Object)AcceptMimeTypeHandler.ANY_MIMETYPE)) == null) {
            return QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfMimeType(@NonNull String string) {
        return this.getQualityOfMimeType((IMimeType)MimeTypeParser.safeParseMimeType((String)string));
    }

    public double getQualityOfMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return 0.0;
        }
        return this.getQValueOfMimeType(iMimeType).getQuality();
    }

    public boolean supportsMimeType(@NonNull String string) {
        return this.supportsMimeType((IMimeType)MimeTypeParser.safeParseMimeType((String)string));
    }

    public boolean supportsMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return false;
        }
        return this.getQValueOfMimeType(iMimeType).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsMimeType(@NonNull String string) {
        return this.explicitlySupportsMimeType((IMimeType)MimeTypeParser.safeParseMimeType((String)string));
    }

    public boolean explicitlySupportsMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return false;
        }
        QValue qValue = (QValue)this.qvalueMap().get((Object)iMimeType);
        return qValue != null && qValue.isAboveMinimumQuality();
    }

    public @Nullable IMimeType getPreferredMimeType(IMimeType ... iMimeTypeArray) {
        IMimeType iMimeType = null;
        QValue qValue = null;
        if (iMimeTypeArray != null) {
            for (IMimeType iMimeType2 : iMimeTypeArray) {
                QValue qValue2 = this.getQValueOfMimeType(iMimeType2);
                if (!qValue2.isAboveMinimumQuality() || qValue != null && qValue2.compareTo(qValue) <= 0) continue;
                iMimeType = iMimeType2;
                qValue = qValue2;
            }
        }
        return iMimeType;
    }

    @Override
    public @NonNull String getAsHttpHeaderValue() {
        return this.getAsHttpHeaderValue(IMimeType::getAsString);
    }
}

