/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.security;

import com.helger.base.debug.GlobalDebug;
import com.helger.base.tostring.ToStringGenerator;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagerTrustAll
implements X509TrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustManagerTrustAll.class);
    private final boolean m_bDebug;

    public TrustManagerTrustAll() {
        this(GlobalDebug.isDebugMode());
    }

    public TrustManagerTrustAll(boolean bl) {
        this.m_bDebug = bl;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    @Override
    public @Nullable X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        if (this.m_bDebug) {
            LOGGER.info("checkServerTrusted (" + Arrays.toString(x509CertificateArray) + ", " + string + ")");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        if (this.m_bDebug) {
            LOGGER.info("checkClientTrusted (" + Arrays.toString(x509CertificateArray) + ", " + string + ")");
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Debug", this.m_bDebug).getToString();
    }
}

