/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.AbstractQValueList;
import com.helger.http.header.QValue;
import java.util.Locale;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public class AcceptLanguageList
extends AbstractQValueList<String> {
    private static @NonNull String _unify(@NonNull String string) {
        return string.toLowerCase(Locale.US);
    }

    public @NonNull AcceptLanguageList addLanguage(@NonNull String string, @Nonnegative double d) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Language");
        this.qvalueMap().put((Object)AcceptLanguageList._unify(string), (Object)new QValue(d));
        return this;
    }

    public @NonNull QValue getQValueOfLanguage(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Language");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptLanguageList._unify(string));
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)"*")) == null) {
            return QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfLanguage(@NonNull String string) {
        return this.getQValueOfLanguage(string).getQuality();
    }

    public boolean supportsLanguage(@NonNull String string) {
        return this.getQValueOfLanguage(string).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsLanguage(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Language");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptLanguageList._unify(string));
        return qValue != null && qValue.isAboveMinimumQuality();
    }

    @Override
    public @NonNull String getAsHttpHeaderValue() {
        return this.getAsHttpHeaderValue(Function.identity());
    }
}

