/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.AbstractQValueList;
import com.helger.http.header.QValue;
import com.helger.http.header.specific.AcceptCharsetHandler;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public class AcceptCharsetList
extends AbstractQValueList<String> {
    private static @NonNull String _unify(@NonNull String string) {
        return string.toLowerCase(Locale.US);
    }

    public @NonNull AcceptCharsetList addCharset(@NonNull Charset charset, @Nonnegative double d) {
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return this.addCharset(charset.name(), d);
    }

    public @NonNull AcceptCharsetList addCharset(@Nonempty @NonNull String string, @Nonnegative double d) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Charset");
        this.qvalueMap().put((Object)AcceptCharsetList._unify(string), (Object)new QValue(d));
        return this;
    }

    public @NonNull QValue getQValueOfCharset(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Charset");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptCharsetList._unify(string));
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)"*")) == null) {
            return string.equals(AcceptCharsetHandler.DEFAULT_CHARSET) ? QValue.MAX_QVALUE : QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfCharset(@NonNull String string) {
        return this.getQValueOfCharset(string).getQuality();
    }

    public boolean supportsCharset(@NonNull String string) {
        return this.getQValueOfCharset(string).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsCharset(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Charset");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptCharsetList._unify(string));
        return qValue != null && qValue.isAboveMinimumQuality();
    }

    @Override
    public @NonNull String getAsHttpHeaderValue() {
        return this.getAsHttpHeaderValue(Function.identity());
    }
}

