/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.http.header.specific.AcceptCharsetList;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class AcceptCharsetHandler {
    public static final String ANY_CHARSET = "*";
    public static final String DEFAULT_CHARSET = StandardCharsets.ISO_8859_1.name();
    private static final AcceptCharsetHandler INSTANCE = new AcceptCharsetHandler();

    private AcceptCharsetHandler() {
    }

    public static @NonNull AcceptCharsetList getAcceptCharsets(@Nullable String string) {
        AcceptCharsetList acceptCharsetList = new AcceptCharsetList();
        if (StringHelper.isEmpty((String)string)) {
            acceptCharsetList.addCharset(ANY_CHARSET, 1.0);
        } else {
            for (String string2 : StringHelper.getExploded((char)',', (String)string)) {
                String[] stringArray = StringHelper.getExplodedArray((char)';', (String)string2.trim(), (int)2);
                double d = 1.0;
                if (stringArray.length == 2 && stringArray[1].trim().startsWith("q=")) {
                    d = StringParser.parseDouble((String)stringArray[1].trim().substring(2), (double)1.0);
                }
                acceptCharsetList.addCharset(stringArray[0], d);
            }
        }
        return acceptCharsetList;
    }
}

