/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.http.header.specific.AcceptLanguageList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class AcceptLanguageHandler {
    public static final String ANY_LANGUAGE = "*";
    private static final AcceptLanguageHandler INSTANCE = new AcceptLanguageHandler();

    private AcceptLanguageHandler() {
    }

    @Nonnull
    public static AcceptLanguageList getAcceptLanguages(@Nullable String string) {
        AcceptLanguageList acceptLanguageList = new AcceptLanguageList();
        if (StringHelper.isEmpty((String)string)) {
            acceptLanguageList.addLanguage(ANY_LANGUAGE, 1.0);
        } else {
            for (String string2 : StringHelper.getExploded((char)',', (String)string)) {
                String[] stringArray = StringHelper.getExplodedArray((char)';', (String)string2.trim(), (int)2);
                double d = 1.0;
                if (stringArray.length == 2 && stringArray[1].trim().startsWith("q=")) {
                    d = StringParser.parseDouble((String)stringArray[1].trim().substring(2), (double)1.0);
                }
                acceptLanguageList.addLanguage(stringArray[0], d);
            }
        }
        return acceptLanguageList;
    }
}

