/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.base.url.EURLProtocol;
import com.helger.base.url.IURLProtocol;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.http.url.ISimpleURL;
import com.helger.http.url.IURLProtocolRegistrarSPI;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class URLProtocolRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLProtocolRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, IURLProtocol> m_aProtocols = new CommonsHashMap();

    private URLProtocolRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static URLProtocolRegistry getInstance() {
        URLProtocolRegistry uRLProtocolRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return uRLProtocolRegistry;
    }

    public void registerProtocol(@Nonnull IURLProtocol iURLProtocol) {
        ValueEnforcer.notNull((Object)iURLProtocol, (String)"Protocol");
        String string = iURLProtocol.getProtocol();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aProtocols.containsKey((Object)string)) {
                throw new IllegalArgumentException("Another handler for protocol '" + string + "' is already registered!");
            }
            this.m_aProtocols.put((Object)string, (Object)iURLProtocol);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered new custom URL protocol: " + String.valueOf(iURLProtocol));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<IURLProtocol> getAllProtocols() {
        return (ICommonsCollection)this.m_aRWLock.readLockedGet(() -> this.m_aProtocols.copyOfValues());
    }

    @Nonnegative
    public int getRegisteredProtocolCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aProtocols.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IURLProtocol getProtocol(@Nullable String string) {
        if (string == null) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            for (IURLProtocol iURLProtocol : this.m_aProtocols.values()) {
                if (!iURLProtocol.isUsedInURL(string)) continue;
                IURLProtocol iURLProtocol2 = iURLProtocol;
                return iURLProtocol2;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nullable
    public IURLProtocol getProtocol(@Nullable ISimpleURL iSimpleURL) {
        return iSimpleURL == null ? null : this.getProtocol(iSimpleURL.getPath());
    }

    public boolean hasKnownProtocol(@Nullable String string) {
        return this.getProtocol(string) != null;
    }

    public boolean hasKnownProtocol(@Nullable ISimpleURL iSimpleURL) {
        return this.getProtocol(iSimpleURL) != null;
    }

    @Nullable
    public String getWithoutProtocol(@Nullable String string) {
        IURLProtocol iURLProtocol = this.getProtocol(string);
        return iURLProtocol == null ? string : string.substring(iURLProtocol.getProtocol().length());
    }

    @Nullable
    public String getWithProtocolIfNone(@Nonnull IURLProtocol iURLProtocol, @Nullable String string) {
        ValueEnforcer.notNull((Object)iURLProtocol, (String)"Protocol");
        if (string == null || this.hasKnownProtocol(string)) {
            return string;
        }
        return iURLProtocol.getWithProtocol(string);
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aProtocols.clear();
            for (EURLProtocol eURLProtocol : EURLProtocol.values()) {
                this.m_aProtocols.put((Object)eURLProtocol.getProtocol(), (Object)eURLProtocol);
            }
        });
        for (IURLProtocolRegistrarSPI iURLProtocolRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IURLProtocolRegistrarSPI.class)) {
            ICommonsSet<? extends IURLProtocol> iCommonsSet = iURLProtocolRegistrarSPI.getAllProtocols();
            if (iCommonsSet == null) continue;
            for (IURLProtocol iURLProtocol : iCommonsSet) {
                this.registerProtocol(iURLProtocol);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getRegisteredProtocolCount() + " URL protocols registered");
        }
    }

    private static final class SingletonHolder {
        private static final URLProtocolRegistry INSTANCE = new URLProtocolRegistry();

        private SingletonHolder() {
        }
    }
}

